package com.xdja.im.lib.album.bean;

/**
 * @Package: com.xdja.im.lib.album.bean
 * @Author: xdjaxa
 * @Creation: 2017-04-24 11:14
 * @Version V1.0
 * @Description:
 */
public class ImageItem {

    /**
     * 图片文件名
     */
    private String name;
    /**
     * 图片绝对路径
     */
    private String path;
    /**
     * 图片文件大小
     */
    private long size;
    /**
     * 图片宽度
     */
    private int width;
    /**
     * 图片高度
     */
    private int height;
    /**
     * 图片类型
     */
    private int type;
    /**
     * 图片创建时间
     */
    private long addTime;
    /**
     * 原图选择状态 {@code false}：未选择 {@code true}：选择
     */
    private boolean bOriginal;

    public ImageItem(String name, String path, long size) {
        this.name = name;
        this.path = path;
        this.size = size;
    }

    public ImageItem(String name, String path, long size, int width, int height, int type) {
        this.name = name;
        this.path = path;
        this.size = size;
        this.width = width;
        this.height = height;
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public long getSize() {
        return size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public int getWidth() {
        return width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public long getAddTime() {
        return addTime;
    }

    public void setAddTime(long addTime) {
        this.addTime = addTime;
    }

    public boolean isOriginal() {
        return bOriginal;
    }

    public void setOriginalState(boolean bOriginal) {
        this.bOriginal = bOriginal;
    }

    @Override
    public String toString() {
        return "ImageItem{" +
                "name='" + name + '\'' +
                ", path='" + path + '\'' +
                ", size=" + size +
                ", width=" + width +
                ", height=" + height +
                ", type=" + type +
                ", addTime=" + addTime +
                ", bOriginal=" + bOriginal +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ImageItem imageItem = (ImageItem) o;

        return path != null ? path.equals(imageItem.path) : imageItem.path == null;

    }

    @Override
    public int hashCode() {
        return path != null ? path.hashCode() : 0;
    }
}
