package com.xdja.im.lib.album.ui.viewholder;

import android.app.Activity;
import android.support.annotation.IdRes;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;

import com.xdja.im.lib.album.ImagePickerManager;
import com.xdja.im.lib.album.bean.ImageItem;
import com.xdja.im.lib.album.listener.OnItemClickListener;
import com.xdja.im.lib.album.listener.OnItemDataChangedListener;

/**
 * @Package: com.xdja.im.lib.album.ui.viewholder
 * @Author: xdjaxa
 * @Creation: 2017-04-24 16:31
 * @Version V1.0
 * @Description:
 */
public abstract class BaseViewHolder extends RecyclerView.ViewHolder {

    public Activity mActivity;

    public View mItemView;

    /**
     * 栏目点击监听器
     */
    protected OnItemClickListener mItemClickListener;

    /**
     * 栏目数据变化监听器
     */
    protected OnItemDataChangedListener mItemDataChangedListener;

    /**
     * 加载数据
     *
     * @param data 数据
     */
    public abstract void bindData(final ImageItem data);

    /**
     * 每个条目的大小
     */
    public int mImageSize;

    public BaseViewHolder(Activity activity, View itemView) {
        super(itemView);
        this.mActivity = activity;
        this.mItemView = itemView;

        mImageSize = getImageItemWidth((Activity) itemView.getContext());
        //让图片是个正方形
        itemView.setLayoutParams(new AbsListView.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, mImageSize));
    }

    /**
     * Look for a child view with the given id.  If this view has the given
     * id, return this view.
     *
     * @param id The id to search for.
     * @return The view that has the given id in the hierarchy or null
     */
    protected View findViewById(@IdRes int id){
        return itemView.findViewById(id);
    }

    /**
     * 根据屏幕宽度与密度计算GridView显示的列数， 最少为三列，并获取Item宽度
     *
     * @param activity
     * @return
     */
    private int getImageItemWidth(Activity activity) {

        int columnNum = ImagePickerManager.getInstance().getConfig().getColumnNum();
        int screenWidth = activity.getResources().getDisplayMetrics().widthPixels;
        int densityDpi = activity.getResources().getDisplayMetrics().densityDpi;
        int cols = screenWidth / densityDpi;
        cols = cols < columnNum ? columnNum : cols;
        int columnSpace = (int) ((columnNum - 1) * activity.getResources().getDisplayMetrics().density);
        return (screenWidth - columnSpace * (cols - 1)) / cols;
    }


    public void setOnItemClickListener(OnItemClickListener itemClickListener) {
        this.mItemClickListener = itemClickListener;
    }

    public void setOnItemDataChangedListener(OnItemDataChangedListener itemDataChangedListener) {
        this.mItemDataChangedListener = itemDataChangedListener;
    }
}
