package com.xdja.im.common.imagecompresser;

import java.io.File;

/**
 * @Package: com.xdja.im.common.imagecompresser
 * @Author: xdjaxa
 * @Creation: 2017-07-05 10:51
 * @Version V1.0
 * @Description:图片压缩回调接口
 */
public interface OnCompressListener {

    /**
     * Fired when the compression is started, override to handle in your own code
     */
    void onStart();

    /**
     * Fired when a compression returns successfully, override to handle in your own code
     */
    void onSuccess(File file);

    /**
     * Fired when a compression fails to complete, override to handle in your own code
     */
    void onError(Throwable e);
}
