package com.xdja.im.lib.album;

import android.app.Activity;
import android.content.Intent;
import android.support.v4.app.Fragment;
import android.text.TextUtils;

import com.xdja.im.common.imageloader.DefaultImageLoader;
import com.xdja.im.common.imageloader.ImageLoader;
import com.xdja.im.core.utils.FilePathUtils;
import com.xdja.im.lib.album.ui.activity.ImagePickerActivity;

/**
 * @Package: com.xdja.im.lib.album
 * @Author: xdjaxa
 * @Creation: 2017-04-24 15:37
 * @Version V1.0
 * @Description:相册管理类
 */
public class ImagePickerManager {

    public static final String CACHE_PATH = "ImagePicker";


    private static class ImagePickerManagerInstance {
        private static ImagePickerManager mInstance = new ImagePickerManager();
    }

    private ImagePickerManager() {
    }

    public static ImagePickerManager getInstance() {
        return ImagePickerManagerInstance.mInstance;
    }

    /**
     * 配置项
     */
    private ImagePickerConfig mConfig;

    /**
     * 图片加载器
     */
    private ImageLoader mImageLoader;

    /**
     * 获取图片加载配置信息
     *
     * @return 配置信息
     */
    public ImagePickerConfig getConfig() {
        if (mConfig == null) {
            mConfig = new ImagePickerConfig();
        }
        if (TextUtils.isEmpty(mConfig.getCachePath())) {
            mConfig.setCachePath(FilePathUtils.getImagePath());
        }
        return mConfig;
    }

    /**
     * 设置配置信息
     *
     * @param config 配置信息
     */
    public void setConfig(ImagePickerConfig config) {
        this.mConfig = config;
    }

    /**
     * 获取图片加载器
     *
     * @return 图片加载器
     */
    public ImageLoader getImageLoader() {
        if (mImageLoader == null) {
            mImageLoader = new DefaultImageLoader();
        }
        return mImageLoader;
    }

    /**
     * 设置图片加载器
     *
     * @param imageLoader 图片加载器
     */
    public void setImageLoader(ImageLoader imageLoader) {
        this.mImageLoader = imageLoader;
    }

    /**
     * 打开相册，从fragment启动
     *
     * @param fragment    Fragment实例
     * @param requestCode 请求码
     */
    public void openAlbum(Fragment fragment, int requestCode) {
        Intent intent = new Intent();
        intent.setClass(fragment.getContext(), ImagePickerActivity.class);
        fragment.startActivityForResult(intent, requestCode);
    }

    /**
     * 打开相册，从Activity启动
     *
     * @param activity    Activity实例
     * @param requestCode 请求码
     */
    public void openAlbum(Activity activity, int requestCode) {
        Intent intent = new Intent();
        intent.setClass(activity, ImagePickerActivity.class);
        activity.startActivityForResult(intent, requestCode);
    }
}
