package com.xdja.im.lib.file.utils;

import com.xdja.im.lib.file.bean.FileItem;
import com.xdja.im.lib.file.bean.FileItemNode;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class NodeUtils {

    public static List<FileItemNode> convertData(Map<String, List<FileItem>> dataMaps) {

        List<FileItemNode> beans = new ArrayList<>();
        if (dataMaps.size() == 0) {
            return beans;
        }

        for (Map.Entry<String, List<FileItem>> entry : dataMaps.entrySet()) {
            String title = entry.getKey();
            List<FileItem> lists = new ArrayList<>(entry.getValue());

            FileItemNode bean = new FileItemNode();
            bean.setValue(title);
            bean.setExpand(false);
            bean.setChildList(lists);
            beans.add(bean);

            /*for (FileItem fInfo : entry.getValue()) {
                FileItemNode leafBean = new FileItemNode();
                leafBean.setValue(fInfo);
                leafBean.setChildList(null);
                beans.add(leafBean);
            }*/
        }

        return beans;
    }
}
