package com.xdja.im.uikit;

/**
 * @Package: com.xdja.im.uikit
 * @Author: xdjaxa
 * @Creation: 2017-04-17 14:53
 * @Version V1.0
 * @Description:SDK 相关配置信息
 */
public class UiKitOptions {

    private UiKitOptions() {
    }

    private static class SingletonInstance {
        private static final UiKitOptions mInstance = new UiKitOptions();
    }

    public static UiKitOptions getOptions() {
        return SingletonInstance.mInstance;
    }

    /**
     * 缓存文件绝对路径
     */
    private String cacheDir;

    /**
     * 消息是否需要加密
     */
    private boolean bEncription;

    /**
     * 改字段用于设置，是否跟随系统字体变化，默认跟随
     */
    private boolean changeFontScale;

    public String getCacheDir() {
        return cacheDir;
    }

    public void setCacheDir(String cacheDir) {
        this.cacheDir = cacheDir;
    }

    public boolean isbEncription() {
        return bEncription;
    }

    public void setbEncription(boolean bEncription) {
        this.bEncription = bEncription;
    }

    public boolean isChangeFontScale() {
        return changeFontScale;
    }

    public void setChangeFontScale(boolean changeFontScale) {
        this.changeFontScale = changeFontScale;
    }
}
