package com.xdja.im.uikit.notification;

import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.content.Context;
import android.os.PowerManager;

import com.xdja.im.uikit.utils.log.LogUtil;

import java.util.List;

/**
 * Created by xdjaxa on 2017/5/26.
 */

public class NotifyUtils {

    public static boolean isAppOnForeground(Context context) {
        ActivityManager am = (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
        List<ActivityManager.RunningAppProcessInfo> appInfos = am.getRunningAppProcesses();
        for (ActivityManager.RunningAppProcessInfo info : appInfos) {
            if (info.processName.equals(context.getPackageName())) {
                if (info.importance == ActivityManager.RunningAppProcessInfo.IMPORTANCE_FOREGROUND) {
                    return true;
                }
            }
        }
        return false;
    }

    /**
     * 获取前台activity名称
     *
     * @param context
     * @return
     */
    public static String getCurrentActivityName(Context context) {
        ActivityManager am = (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
        ActivityManager.RunningTaskInfo info = am.getRunningTasks(1).get(0);
        return info.topActivity.getClassName();
    }

    /**
     * 是否是锁屏 或者是 黑屏
     *
     * @param context
     * @return
     */
    public static boolean isScreenOffOrLock(Context context) {
        //获取屏幕是否亮屏
        PowerManager pm = (PowerManager) context.getSystemService(Context.POWER_SERVICE);
        boolean isOn = false;
        boolean isLock = true;
        if (pm != null) {
            isOn = pm.isScreenOn();
        }
        //获取屏幕是否锁屏
        KeyguardManager mKeyguardManager = (KeyguardManager) context.getSystemService(Context.KEYGUARD_SERVICE);
        if (mKeyguardManager != null) {
            try {
                //修改适配android 4.0的获取锁屏状态
                isLock = mKeyguardManager.inKeyguardRestrictedInputMode();
            } catch (Throwable e) {
                LogUtil.e(e.getMessage());
            }
        }

        return !isOn || isLock;
    }
}
