package com.xdja.im.uikit.ui.adapter;

import android.app.Activity;

import com.xdja.im.base.frame.presenter.BaseItemAdapterPresenter;
import com.xdja.im.base.frame.view.AdapterBaseView;
import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.core.proxy.IMUiKitProxyImpl;
import com.xdja.im.uikit.ui.presenter.SessionListAdapterPresenter;
import com.xdja.im.uikit.ui.view.ViewCustomSessionItem;
import com.xdja.im.uikit.ui.view.ViewDefaultSessionItem;
import com.xdja.im.uikit.ui.view.ViewGroupItem;
import com.xdja.im.uikit.ui.view.ViewSingleItem;

import java.util.ArrayList;
import java.util.List;

import rx.Subscriber;

/**
 * @Package: com.xdja.im.uikit.presenter.adapter
 * @Author: xdjaxa
 * @Date: 2017-04-10 18:00
 * @Version V1.0
 * @Comment: 会话列表适配器
 */
public class SessionListAdapter extends BaseItemAdapterPresenter<SessionListAdapterPresenter, TalkSessionBean>
        implements SessionListAdapterPresenter {

    private Activity mActivity;

    private final List<TalkSessionBean> mDataSource;

    private List<Class<? extends AdapterBaseView<SessionListAdapterPresenter, TalkSessionBean>>> vuClasses;

    public SessionListAdapter(Activity activity, List<TalkSessionBean> mDataSource) {
        this.mActivity = activity;
        this.mDataSource = mDataSource;
    }

    @Override
    protected Activity getActivity() {
        return mActivity;
    }

    @Override
    protected List<Class<? extends AdapterBaseView<SessionListAdapterPresenter, TalkSessionBean>>> getVuClasses() {
        if (this.vuClasses == null) {
            this.vuClasses = new ArrayList<>();
            this.vuClasses.add(ViewSingleItem.class);
            this.vuClasses.add(ViewGroupItem.class);
            this.vuClasses.add(ViewCustomSessionItem.class);
            this.vuClasses.add(ViewDefaultSessionItem.class);
        }
        return vuClasses;
    }

    @Override
    public int getViewTypeCount() {
        return getVuClasses() != null ? getVuClasses().size() : 0;
    }

    @Override
    public int getItemViewType(int position) {
        if (mDataSource != null) {
            int talkType = mDataSource.get(position).getTalkType();
            switch (talkType) {
                case ConstDef.CHAT_TYPE_P2P:
                    return 0;
                case ConstDef.CHAT_TYPE_P2G:
                    return 1;
                case ConstDef.CHAT_TYPE_CUSTOM:
                    return 2;
                default:
                    return 3;
            }
        }
        return 3;
    }

    @Override
    protected Class<? extends AdapterBaseView<SessionListAdapterPresenter, TalkSessionBean>> getVuClassByViewType(int itemViewType) {
        return this.getVuClasses().get(itemViewType);
    }

    @Override
    protected SessionListAdapterPresenter getPresenter() {
        return this;
    }

    @Override
    protected TalkSessionBean getDataSource(int position) {
        return mDataSource == null ? null : mDataSource.get(position);
    }

    @Override
    public int getCount() {
        return mDataSource == null ? 0 : mDataSource.size();
    }

    @Override
    public Object getItem(int position) {
        return mDataSource.get(position);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public void getAccount(String account, int talkType, Subscriber<AccountBean> subscriber) {
        IMUiKitProxyImpl.getInstance().getAccount(account, talkType, subscriber);
    }
}
