package com.xdja.im.uikit.ui.view;

import android.annotation.TargetApi;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorRes;
import android.support.annotation.NonNull;
import android.text.Html;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.xdja.im.base.frame.view.AdapterBaseView;
import com.xdja.im.base.frame.view.AdapterSuperBaseView;
import com.xdja.im.common.imageloader.GlideCircleTransform;
import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.core.model.param.SessionParam;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.ui.presenter.SessionListAdapterPresenter;
import com.xdja.im.uikit.utils.StringUtils;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.utils.sys.TimeUtil;

import rx.Subscriber;

/**
 * @Package:com.xdja.im.uikit.ui
 * @Author:Lei
 * @Creation:2017-04-13 00:37
 * @Version 1.0
 * @Description:
 */
public class ViewSessionItem extends AdapterSuperBaseView<SessionListAdapterPresenter, TalkSessionBean>
        implements AdapterBaseView<SessionListAdapterPresenter, TalkSessionBean> {

    private LinearLayout mLayout;
    /**
     * 头像
     */
    private ImageView mUserHeader;
    /**
     * 未读消息条数(开启免打扰模式时，为未读消息提示)
     */
    private TextView mUnReadCountTv;
    /**
     * 新消息标识
     */
    private ImageView mNewMsgFlagImg;
    /**
     * 用户名称
     */
    private TextView mUserNameTv;
    /**
     * 消息内容
     */
    private TextView mContentTv;
    /**
     * 消息状态
     */
    private ImageView mMessageStateImg;
    /**
     * 会话展示时间
     */
    private TextView mDisplayTimeTv;
    /**
     * 免打扰标识
     */
    private ImageView mDisturbFlag;

    @Override
    protected void injectView() {
        super.injectView();
        mLayout = (LinearLayout) findViewById(R.id.layout_session_item);
        mUserHeader = (ImageView) findViewById(R.id.img_user_header);
        mUnReadCountTv = (TextView) findViewById(R.id.tv_unread_message);
        mNewMsgFlagImg = (ImageView) findViewById(R.id.img_new_message_flag);
        mUserNameTv = (TextView) findViewById(R.id.tv_user_name);
        mContentTv = (TextView) findViewById(R.id.tv_content);
        mMessageStateImg = (ImageView) findViewById(R.id.img_message_state);
        mDisplayTimeTv = (TextView) findViewById(R.id.tv_display_time);
        mDisturbFlag = (ImageView) findViewById(R.id.img_disturb_flag);
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkSessionBean dataSource) {
        super.bindDataSource(position, dataSource);
        if (dataSource == null) {
            LogUtil.e("dataSource is null.");
            return;
        }

        String lastMsgId = dataSource.getLastMsgAccount();
//        if (StringUtils.isEmpty(lastMsgId)) {
//            updateContentData("");
//        } else {
//            getPresenter().getAccount(dataSource.getLastMsgAccount(), ConstDef.CHAT_TYPE_P2P, new Subscriber<AccountBean>() {
//                @Override
//                public void onCompleted() {
//                }
//
//                @Override
//                public void onError(Throwable e) {
//
//                }
//
//                @Override
//                public void onNext(AccountBean accountBean) {
//                    updateContentData(accountBean.getDisplayName());
//                }
//            });
//        }
        updateUnreadCount();
        updateMessageState();
        updateSessionParam();
    }

    /**
     * 会话配置相关信息设置
     */
    private void updateSessionParam() {
        if (dataSource.getParam() != null) {
            //草稿
            /*if (!TextUtils.isEmpty(dataSource.getParam().getDraftContent()) &&
                    dataSource.getParam().getDraftTime() > 0) {
                setTextColor(R.color.base_red_80);
            } else {
                setTextColor(R.color.base_black_65);
            }*/

            //置顶
            if (dataSource.getParam().isTop()) {
                mLayout.setBackgroundResource(R.drawable.im_uikit_bg_session_item_top);
            } else {
                mLayout.setBackgroundResource(R.drawable.im_uikit_bg_session_item_normal);
            }

            //免打扰
            if (dataSource.getParam().isDisturb()) {
                mDisturbFlag.setVisibility(View.VISIBLE);
            } else {
                mDisturbFlag.setVisibility(View.GONE);
            }
        } else {
            mDisturbFlag.setVisibility(View.GONE);
            mLayout.setBackgroundResource(R.drawable.im_uikit_bg_session_item_normal);
        }
    }

    /**
     * 加载用户信息
     */
    private void updateContentData(String displayName) {
        mContentTv.setText(ellipsize(getContent(displayName)));
        mDisplayTimeTv.setText(getDisplayTime());

        final String account = dataSource.getTalkerAccount();
        if (TextUtils.isEmpty(account)) {
            LogUtil.e("ERROR: User account is null.");
            return;
        }
        //防止用户名称加载错乱
        mUserNameTv.setTag(account);

        getPresenter().getAccount(account, dataSource.getTalkType(), new Subscriber<AccountBean>() {
            @Override
            public void onCompleted() {

            }

            @Override
            public void onError(Throwable e) {
                mUserNameTv.setText(account);
            }

            @Override
            public void onNext(AccountBean accountBean) {
                if (accountBean == null) {
                    mUserNameTv.setText(account);
                    return;
                }
                if (!TextUtils.isEmpty(accountBean.getDisplayName())) {
                    mUserNameTv.setText(accountBean.getDisplayName());
                } else {
                    mUserNameTv.setText(account);
                }

                Drawable avatarDrawable = accountBean.getAvatarDrawable();
                if (avatarDrawable != null) {
                    mUserHeader.setImageDrawable(avatarDrawable);
                    return;
                }

                int imgId = R.mipmap.im_uikit_user_header_40dp;
                if (dataSource.getTalkType() == ConstDef.CHAT_TYPE_P2G) {
                    imgId = R.mipmap.im_uikit_group_avatar_40;
                }
                String avatarUrl = accountBean.getAvatarUrl();
                if (!TextUtils.isEmpty(avatarUrl)) {
                    Glide.with(getActivity())
                            .load(avatarUrl)
                            .placeholder(imgId)
                            .error(imgId)
                            .bitmapTransform(new GlideCircleTransform(getContext()))
                            .into(mUserHeader);
                    return;
                }
                mUserHeader.setImageResource(imgId);
            }
        });

    }

    /**
     * 更新消息状态
     */
    private void updateMessageState() {
        TalkMessageBean talkMessageBean = dataSource.getLastMsg();
        if (talkMessageBean == null) {
            LogUtil.w("session last message is null.");
            return;
        }

        mMessageStateImg.setVisibility(View.GONE);
        //自定义消息
        if (talkMessageBean.getMessageType() == ConstDef.MSG_TYPE_PRESENTATION) {
            return;
        }

        if (talkMessageBean.getFrom() == null || talkMessageBean.getTo() == null) {
            return;
        }

        //存在草稿，不更新状态
        SessionParam param = dataSource.getParam();
        if (param != null && !TextUtils.isEmpty(param.getDraftContent()) &&
                param.getDraftTime() > 0) {
            return;
        }

        //发送中
        if (talkMessageBean.getMessageState() == ConstDef.STATE_SENDING) {
            mMessageStateImg.setVisibility(View.VISIBLE);
            mMessageStateImg.setImageResource(R.mipmap.im_uikit_ic_message_state_sending);
        }

        //发送失败
        else if (talkMessageBean.getMessageState() == ConstDef.STATE_SEND_FAILED) {
            mMessageStateImg.setVisibility(View.VISIBLE);
            mMessageStateImg.setImageResource(R.mipmap.im_uikit_ic_message_state_fail);
        }
    }

    /**
     * 设置未读消息个数
     */
    private void updateUnreadCount() {

        int notReadCount = dataSource.getNotReadCount();
        if (notReadCount > 0) {
            setNotReadShow(true);

            SessionParam param = dataSource.getParam();
            if (param != null && param.isDisturb()) {
                mUnReadCountTv.setVisibility(View.GONE);
                mNewMsgFlagImg.setVisibility(View.VISIBLE);
                return;
            }
            if (notReadCount > 99) {
                setNotReadCount(Html.fromHtml("<b>...</b>"));
            } else {
                setNotReadCount(notReadCount + "");
            }
        } else {
            setNotReadShow(false);
        }
    }

    /**
     * 设置是否显示未读消息标识
     *
     * @param isShow {@code true} 显示未读标识 {@code false} 不显示未读标识
     */
    private void setNotReadShow(boolean isShow) {
        if (isShow) {
            mUnReadCountTv.setVisibility(View.VISIBLE);
        } else {
            mUnReadCountTv.setVisibility(View.GONE);
        }
        mNewMsgFlagImg.setVisibility(View.GONE);
    }

    /**
     * 设置未读消息显示
     *
     * @param countText 显示内容
     */
    private void setNotReadCount(CharSequence countText) {
        mUnReadCountTv.setText(countText);
    }

    /**
     * 设置文本显示颜色
     *
     * @param idRes
     */
    private void setTextColor(@ColorRes int idRes) {
        mContentTv.setTextColor(getColorRes(idRes));
    }

    /**
     * 用去用户名称
     *
     * @return
     */
    protected String getUserName() {
        return dataSource.getLastMsgAccount();
    }

    /**
     * 获取显示内容
     *
     * @return
     */
    protected CharSequence getContent(String displayName) {
        return "";
    }

    /**
     * 获取显示时间
     *
     * @return 时间字符串
     */
    protected String getDisplayTime() {
        // TODO: 2017/7/12 暂时显示最后一条消息时间，待产品给出定义
        if (dataSource.getLastTime() > 0) {
            return TimeUtil.convertSessionTime(dataSource.getLastTime());
        }
        return "";
    }

    public void setTimeVisibility(int visibility) {
        mDisplayTimeTv.setVisibility(visibility);
    }

    /**
     * 草稿格式化
     *
     * @param content
     * @return
     */
    protected CharSequence formatDraft(String content) {
        String draftPreStr = "<font color=\"#941100\">" +
                                getStringRes(R.string.im_uikit_draft) +
                             "</font>";
        return Html.fromHtml(draftPreStr + content);
    }

    /**
     * 文本省略
     *
     * @param content
     * @return
     */
    @TargetApi(Build.VERSION_CODES.JELLY_BEAN)
    protected CharSequence ellipsize(CharSequence content) {
        return TextUtils.ellipsize(content, mContentTv.getPaint(),
                mContentTv.getMaxWidth() - 8, TextUtils.TruncateAt.END);
    }
}
