/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.common.utils;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Process;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.AppOpsManagerCompat;
import android.support.v4.content.PermissionChecker;
import android.support.v4.util.SimpleArrayMap;

public class PermissionUtils {
    private static final SimpleArrayMap<String, Integer> MIN_SDK_PERMISSIONS = new SimpleArrayMap(8);

    public static void requestPermissions(Activity activity, @NonNull String[] permissions, @IntRange(from=0L) int requestCode) {
        ActivityCompat.requestPermissions((Activity)activity, (String[])permissions, (int)requestCode);
    }

    public static boolean hasSelfPermissions(Context context, String ... permissions) {
        for (String permission2 : permissions) {
            if (!PermissionUtils.permissionExists(permission2) || PermissionUtils.hasSelfPermission(context, permission2)) continue;
            return false;
        }
        return true;
    }

    private static boolean permissionExists(String permission2) {
        Integer minVersion = (Integer)MIN_SDK_PERMISSIONS.get((Object)permission2);
        return minVersion == null || Build.VERSION.SDK_INT >= minVersion;
    }

    private static boolean hasSelfPermission(Context context, String permission2) {
        if (Build.VERSION.SDK_INT >= 23 && "Xiaomi".equalsIgnoreCase(Build.MANUFACTURER)) {
            return PermissionUtils.hasSelfPermissionForXiaomi(context, permission2);
        }
        try {
            return PermissionChecker.checkSelfPermission((Context)context, (String)permission2) == 0;
        }
        catch (RuntimeException t) {
            return false;
        }
    }

    private static boolean hasSelfPermissionForXiaomi(Context context, String permission2) {
        String permissionToOp = AppOpsManagerCompat.permissionToOp((String)permission2);
        if (permissionToOp == null) {
            return true;
        }
        int noteOp = AppOpsManagerCompat.noteOp((Context)context, (String)permissionToOp, (int)Process.myUid(), (String)context.getPackageName());
        return noteOp == 0 && PermissionChecker.checkSelfPermission((Context)context, (String)permission2) == 0;
    }

    public static boolean shouldShowRequestPermissionRationale(Activity activity, String ... permissions) {
        for (String permission2 : permissions) {
            if (!ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)permission2)) continue;
            return true;
        }
        return false;
    }

    static {
        MIN_SDK_PERMISSIONS.put((Object)"com.android.voicemail.permission.ADD_VOICEMAIL", (Object)14);
        MIN_SDK_PERMISSIONS.put((Object)"android.permission.BODY_SENSORS", (Object)20);
        MIN_SDK_PERMISSIONS.put((Object)"android.permission.READ_CALL_LOG", (Object)16);
        MIN_SDK_PERMISSIONS.put((Object)"android.permission.READ_EXTERNAL_STORAGE", (Object)16);
        MIN_SDK_PERMISSIONS.put((Object)"android.permission.USE_SIP", (Object)9);
        MIN_SDK_PERMISSIONS.put((Object)"android.permission.WRITE_CALL_LOG", (Object)16);
        MIN_SDK_PERMISSIONS.put((Object)"android.permission.SYSTEM_ALERT_WINDOW", (Object)23);
        MIN_SDK_PERMISSIONS.put((Object)"android.permission.WRITE_SETTINGS", (Object)23);
    }
}

