/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.album.ui.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.MotionEvent;
import com.xdja.im.common.imageloader.CustomImageLoader;
import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.common.utils.PermissionUtils;
import com.xdja.im.lib.album.ImageDataSource;
import com.xdja.im.lib.album.ImagePickerManager;
import com.xdja.im.lib.album.bean.ImageItem;
import com.xdja.im.lib.album.bean.ImageThumbBean;
import com.xdja.im.lib.album.listener.OnItemClickListener;
import com.xdja.im.lib.album.listener.OnItemDataChangedListener;
import com.xdja.im.lib.album.ui.activity.ImagePreviewActivity;
import com.xdja.im.lib.album.ui.adapter.ImagePickerAdapter;
import com.xdja.im.lib.album.ui.presenter.ImagePickerPresenter;
import com.xdja.im.lib.album.ui.view.ViewImagePicker;
import com.xdja.im.lib.album.ui.view.vu.ImagePickerVu;
import com.xdja.im.lib.album.utils.DataTools;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.base.ImBaseActivity;
import com.xdja.im.uikit.utils.log.LogUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import rx.Observable;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

public class ImagePickerActivity
extends ImBaseActivity<ImagePickerPresenter, ImagePickerVu>
implements ImagePickerPresenter {
    private List<ImageItem> mImageItemList = new ArrayList<ImageItem>();
    private ImagePickerAdapter mAdapter;
    private boolean bSendingImage = false;
    private OnItemClickListener onItemClickListener = new OnItemClickListener(){

        @Override
        public void onItemClick(int position, ImageItem item) {
            Intent intent = new Intent();
            intent.setClass((Context)ImagePickerActivity.this, ImagePreviewActivity.class);
            intent.putExtra("P_Type", 0);
            intent.putExtra("P_Position", position);
            ImagePickerActivity.this.startActivityForResult(intent, 0);
        }
    };
    private OnItemDataChangedListener onItemDataChangedListener = new OnItemDataChangedListener(){

        @Override
        public void onDataChanged(int position, boolean isChecked) {
            ImageItem imageItem = ImagePickerActivity.this.mAdapter.getItemData(position);
            if (imageItem == null) {
                return;
            }
            LogUtil.d("onDataChanged, isChecked:" + isChecked + ",imageItem:" + imageItem.toString());
            if (isChecked) {
                ImageDataSource.getInstance().add(imageItem);
            } else {
                ImageDataSource.getInstance().remove(imageItem);
            }
            ((ImagePickerVu)ImagePickerActivity.this.getVu()).refreshSelectPictureIndicator();
        }
    };

    @Override
    @NonNull
    protected Class<? extends ImagePickerVu> getVuClass() {
        return ViewImagePicker.class;
    }

    @Override
    @NonNull
    protected ImagePickerPresenter getPresenter() {
        return this;
    }

    @Override
    protected void preBindView(@Nullable Bundle savedInstanceState) {
        super.preBindView(savedInstanceState);
        this.requestPermission();
    }

    @Override
    protected void onBindView(@Nullable Bundle savedInstanceState) {
        super.onBindView(savedInstanceState);
        this.syncGalley();
    }

    protected void onResume() {
        super.onResume();
        ((ImagePickerVu)this.getVu()).refreshSelectPictureIndicator();
        if (this.mAdapter != null) {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    private void syncGalley() {
        Intent scanIntent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
        scanIntent.setData(Uri.fromFile((File)new File(Environment.getExternalStorageDirectory().getAbsolutePath())));
        this.sendBroadcast(scanIntent);
    }

    private void requestPermission() {
        if (PermissionUtils.hasSelfPermissions((Context)this, "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE")) {
            this.loadData();
        } else {
            PermissionUtils.requestPermissions((Activity)this, new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"}, 1);
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 1) {
            if (grantResults.length > 0 && grantResults[0] == 0) {
                this.loadData();
            } else {
                this.showToast(R.string.im_uikit_storage_deny);
            }
        }
    }

    private void loadData() {
        Observable.just((Object)"").subscribeOn(Schedulers.newThread()).flatMap((Func1)new Func1<String, Observable<List<ImageItem>>>(){

            public Observable<List<ImageItem>> call(String s) {
                List<ImageItem> data = DataTools.loadImageData((Context)ImagePickerActivity.this);
                return Observable.just(data);
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<List<ImageItem>>(){

            public void onCompleted() {
                ((ImagePickerVu)ImagePickerActivity.this.getVu()).setProgressBarVisible(false);
            }

            public void onError(Throwable e) {
                LogUtil.e("load image failed! " + e.getMessage());
                ((ImagePickerVu)ImagePickerActivity.this.getVu()).setEmptyLayoutVisible();
                ((ImagePickerVu)ImagePickerActivity.this.getVu()).setProgressBarVisible(false);
            }

            public void onNext(List<ImageItem> imageItems) {
                if (imageItems == null || imageItems.isEmpty()) {
                    ((ImagePickerVu)ImagePickerActivity.this.getVu()).setEmptyLayoutVisible();
                    return;
                }
                ImageDataSource.getInstance().addAll(imageItems);
                ImagePickerActivity.this.mImageItemList.clear();
                ImagePickerActivity.this.mImageItemList.addAll(imageItems);
                ImagePickerActivity.this.mAdapter = ImagePickerActivity.this.buildAdapter(ImagePickerActivity.this.mImageItemList);
                ((ImagePickerVu)ImagePickerActivity.this.getVu()).setAdapter(ImagePickerActivity.this.mAdapter);
            }
        });
    }

    public ImagePickerAdapter buildAdapter(List<ImageItem> imageItemList) {
        return new ImagePickerAdapter((Activity)this, imageItemList){

            @Override
            public OnItemClickListener getOnItemClickListener() {
                return ImagePickerActivity.this.onItemClickListener;
            }

            @Override
            public OnItemDataChangedListener getOnItemDataChangedListener() {
                return ImagePickerActivity.this.onItemDataChangedListener;
            }
        };
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        this.bSendingImage = false;
        ImageDataSource.getInstance().clearCache();
        if (ImagePickerManager.getInstance().getImageLoader() != null) {
            ImagePickerManager.getInstance().getImageLoader().clearMemoryCache((Activity)this);
        }
        CustomImageLoader.getInstance().clearCache();
    }

    @Override
    public void sendImage(List<ImageItem> dataList) {
        if (dataList == null || dataList.isEmpty()) {
            return;
        }
        this.bSendingImage = true;
        ((ImagePickerVu)this.getVu()).setProgressBarVisible(true);
        Observable.from(dataList).subscribeOn(Schedulers.newThread()).flatMap((Func1)new Func1<ImageItem, Observable<ImageThumbBean>>(){

            public Observable<ImageThumbBean> call(ImageItem imageItem) {
                return DataTools.createThumbNails(imageItem);
            }
        }).toList().observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<List<ImageThumbBean>>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.e("Create thumbnail error, " + e.getMessage());
                ImagePickerActivity.this.bSendingImage = false;
                ((ImagePickerVu)ImagePickerActivity.this.getVu()).setProgressBarVisible(false);
                CommonTool.showToast(R.string.im_uikit_send_image_failed);
            }

            public void onNext(List<ImageThumbBean> imageThumbBeen) {
                ImagePickerActivity.this.setResult(imageThumbBeen);
            }
        });
    }

    @Override
    public void preView() {
        Intent intent = new Intent();
        intent.setClass((Context)this, ImagePreviewActivity.class);
        intent.putExtra("P_Type", 1);
        this.startActivityForResult(intent, 0);
    }

    private void setResult(List<ImageThumbBean> thumbBean) {
        Intent intent = new Intent();
        Bundle bundle = new Bundle();
        ArrayList<ImageThumbBean> bundleList = new ArrayList<ImageThumbBean>();
        bundleList.addAll(thumbBean);
        bundle.putParcelableArrayList("album_pic_select", bundleList);
        intent.putExtras(bundle);
        this.setResult(2, intent);
        this.finish();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (data != null) {
            this.setResult(2, data);
            this.finish();
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (this.bSendingImage) {
            return true;
        }
        return super.dispatchTouchEvent(ev);
    }
}

