/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.view;

import android.support.annotation.NonNull;
import android.view.View;
import android.widget.Button;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.action.options.ImOption;
import com.xdja.im.uikit.ui.dialog.BaseListDialog;
import com.xdja.im.uikit.ui.presenter.ChatListAdapterPresenter;
import com.xdja.im.uikit.ui.view.BaseChatItem;
import com.xdja.im.uikit.utils.log.LogUtil;
import java.util.ArrayList;

public class BaseSendItem
extends BaseChatItem {
    protected RelativeLayout mContentLayout;
    private TextView mStateTv;
    private Button mResendBtn;
    private ProgressBar mSendingPBar;

    @Override
    protected void injectView() {
        super.injectView();
        this.mStateTv = (TextView)this.findViewById(R.id.tv_state);
        this.mResendBtn = (Button)this.findViewById(R.id.btn_resend);
        this.mSendingPBar = (ProgressBar)this.findViewById(R.id.pbar_sending);
        this.mContentLayout = (RelativeLayout)this.findViewById(R.id.layout_message_container);
        this.mStateTv.setVisibility(8);
        this.mContentLayout.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                return BaseSendItem.this.showPopDialog();
            }
        });
        this.mResendBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BaseSendItem.this.mResendBtn.setVisibility(8);
                BaseSendItem.this.mSendingPBar.setVisibility(0);
                ((ChatListAdapterPresenter)BaseSendItem.this.getPresenter()).reSendMessage(BaseSendItem.this.curPosition);
            }
        });
        this.mPopDialog.setOnItemClickListener(new BaseListDialog.onItemClickListener(){

            @Override
            public void onItemClick(View view, ImOption option, int itemPosition) {
                BaseSendItem.this.dismissPopDialog();
                switch (option.getOptionType()) {
                    case 1: {
                        ((ChatListAdapterPresenter)BaseSendItem.this.getPresenter()).deleteItem(itemPosition);
                        break;
                    }
                    case 2: {
                        ((ChatListAdapterPresenter)BaseSendItem.this.getPresenter()).copyMessage(itemPosition);
                        break;
                    }
                    case 3: {
                        ((ChatListAdapterPresenter)BaseSendItem.this.getPresenter()).recallMessage(itemPosition);
                        break;
                    }
                    case 4: {
                        ((ChatListAdapterPresenter)BaseSendItem.this.getPresenter()).reSendMessage(itemPosition);
                    }
                }
            }
        });
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkMessageBean dataSource) {
        super.bindDataSource(position, dataSource);
        if (dataSource == null) {
            LogUtil.e("Action:set message state, reason: dataSource is null.");
            return;
        }
        if (dataSource.getMessageState() == 0) {
            this.mResendBtn.setVisibility(0);
            this.mSendingPBar.setVisibility(8);
        }
        int messageState = dataSource.getMessageState();
        if (dataSource.isGroupMsg()) {
            this.mStateTv.setVisibility(8);
        }
        if (messageState == 1) {
            this.setProgressBarVisible(true);
        } else {
            this.setProgressBarVisible(false);
        }
        if (messageState == 0) {
            this.mResendBtn.setVisibility(0);
            this.mSendingPBar.setVisibility(8);
            if (dataSource.getFailCode() == -5) {
                this.mStateTv.setVisibility(0);
                this.mStateTv.setText(dataSource.isGroupMsg() ? R.string.im_uikit_not_member : R.string.im_uikit_not_friend);
            }
        } else {
            this.mResendBtn.setVisibility(8);
        }
        this.setSendLayoutBackground(dataSource.isBomb());
    }

    private void setProgressBarVisible(boolean bVisible) {
        if (bVisible) {
            this.mSendingPBar.setVisibility(0);
        } else {
            this.mSendingPBar.setVisibility(8);
        }
    }

    private void setSendLayoutBackground(boolean isLimit) {
        if (((TalkMessageBean)this.dataSource).getMessageType() == 3 || ((TalkMessageBean)this.dataSource).getMessageType() == 2) {
            return;
        }
        if (this.mContentLayout != null) {
            if (isLimit) {
                this.mContentLayout.setBackgroundResource(R.drawable.im_uikit_bg_send_shan_selector);
                this.setTxtContentColor(this.getLimitTextColor());
            } else {
                this.mContentLayout.setBackgroundResource(R.drawable.im_uikit_bg_send_selector);
                this.setTxtContentColor(this.getNormalTextColor());
            }
        }
    }

    protected void setTxtContentColor(int color) {
    }

    @Override
    public int getNormalTextColor() {
        return -16777216;
    }

    @Override
    public int getLimitTextColor() {
        return -3355444;
    }

    protected boolean showPopDialog() {
        ArrayList<ImOption> data = new ArrayList<ImOption>();
        if (((TalkMessageBean)this.dataSource).getMessageType() == 0) {
            data.add((ImOption)this.mImOptions.get(0));
            data.add((ImOption)this.mImOptions.get(1));
        } else {
            data.add((ImOption)this.mImOptions.get(0));
        }
        if (((TalkMessageBean)this.dataSource).getMessageState() == 0) {
            data.add((ImOption)this.mImOptions.get(3));
        }
        this.mPopDialog.addData(data);
        this.mPopDialog.show(this.curPosition);
        return true;
    }

    protected void dismissPopDialog() {
        if (this.mPopDialog != null) {
            this.mPopDialog.dismiss();
        }
    }

    protected void setMessageVisible(int visibility) {
        this.mStateTv.setVisibility(0);
    }
}

