/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.view;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.core.model.param.SessionParam;
import com.xdja.im.lib.emoji.utils.EmotionUtils;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.ui.view.ViewSessionItem;
import com.xdja.im.uikit.utils.log.LogUtil;

public class ViewGroupItem
extends ViewSessionItem {
    public static final String SEPARATOR = ": ";

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_item_session_group;
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkSessionBean dataSource) {
        super.bindDataSource(position, dataSource);
    }

    @Override
    protected CharSequence getContent(String diaplayName) {
        if (((TalkSessionBean)this.dataSource).getLastMsg() != null && ((TalkSessionBean)this.dataSource).getLastMsg().isMine()) {
            return this.getMessageContent("");
        }
        return this.getMessageContent(diaplayName);
    }

    private CharSequence getMessageContent(String displayName) {
        TalkMessageBean talkMessageBean = ((TalkSessionBean)this.dataSource).getLastMsg();
        SessionParam param = ((TalkSessionBean)this.dataSource).getParam();
        if (param != null && !TextUtils.isEmpty((CharSequence)param.getDraftContent()) && param.getDraftTime() > 0L) {
            CharSequence content = this.formatDraft(param.getDraftContent());
            LogUtil.d("ViewGroupItem draft:" + content);
            return EmotionUtils.formatSpanContent(content, (Context)this.getActivity(), 0.8f);
        }
        if (talkMessageBean == null) {
            LogUtil.w("Last message info is null.");
            return "";
        }
        int messageType = talkMessageBean.getMessageType();
        boolean isMine = ((TalkSessionBean)this.dataSource).getLastMsg().isMine();
        switch (messageType) {
            case 0: {
                if (!isMine) {
                    return EmotionUtils.formatSpanContent(displayName + SEPARATOR + ((TalkSessionBean)this.dataSource).getContent(), (Context)this.getActivity(), 0.8f);
                }
                return EmotionUtils.formatSpanContent(((TalkSessionBean)this.dataSource).getContent(), (Context)this.getActivity(), 0.8f);
            }
            case 1: {
                if (!isMine) {
                    return displayName + SEPARATOR + this.getStringRes(R.string.im_uikit_voice);
                }
                return this.getStringRes(R.string.im_uikit_voice);
            }
            case 2: {
                if (!isMine) {
                    return displayName + SEPARATOR + this.getStringRes(R.string.im_uikit_video);
                }
                return this.getStringRes(R.string.im_uikit_video);
            }
            case 3: {
                if (!isMine) {
                    return displayName + SEPARATOR + this.getStringRes(R.string.im_uikit_image);
                }
                return this.getStringRes(R.string.im_uikit_image);
            }
            case 4: {
                if (!isMine) {
                    return displayName + SEPARATOR + this.getStringRes(R.string.im_uikit_file);
                }
                return this.getStringRes(R.string.im_uikit_file);
            }
        }
        return ((TalkSessionBean)this.dataSource).getContent() == null ? "" : ((TalkSessionBean)this.dataSource).getContent();
    }
}

