/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.db.dao;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import com.xdja.imsdk.db.bean.LocalStateMsgDb;
import com.xdja.imsdk.db.builder.LocalStateMsgBuilder;
import com.xdja.imsdk.db.dao.AbstractDao;
import java.util.ArrayList;
import java.util.List;

public class LocalStateMsgDao
extends AbstractDao<LocalStateMsgDb> {
    private static LocalStateMsgDao instance;

    private LocalStateMsgDao() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LocalStateMsgDao getInstance() {
        if (instance != null) return instance;
        Class<LocalStateMsgDao> clazz = LocalStateMsgDao.class;
        synchronized (LocalStateMsgDao.class) {
            if (instance != null) return instance;
            instance = new LocalStateMsgDao();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public long insert(LocalStateMsgDb state) {
        return this.insert(state, LocalStateMsgBuilder.insertSql());
    }

    public long insert(SQLiteDatabase db, LocalStateMsgDb state) {
        return this.insert(db, state, LocalStateMsgBuilder.insertSql());
    }

    public void insertBatch(SQLiteDatabase db, List<LocalStateMsgDb> states) {
        if (states == null || states.isEmpty()) {
            return;
        }
        this.insertBatch(db, states, LocalStateMsgBuilder.insertSql());
    }

    public int deleteL(String sql) {
        return this.delete(sql);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<LocalStateMsgDb> getStates() {
        ArrayList<LocalStateMsgDb> msgListDb = new ArrayList<LocalStateMsgDb>();
        Cursor cursor = null;
        try {
            try {
                cursor = this.query(LocalStateMsgBuilder.queryAll());
                while (cursor != null) {
                    if (!cursor.moveToNext()) {
                        return msgListDb;
                    }
                    msgListDb.add(this.readEntry(cursor, 0));
                }
                return msgListDb;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.closeCursor(cursor);
                return msgListDb;
            }
        }
        finally {
            this.closeCursor(cursor);
        }
    }

    @Override
    protected void bindValues(SQLiteStatement stmt, LocalStateMsgDb entity) {
        String content;
        Long sendTime;
        stmt.clearBindings();
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id.longValue());
        }
        if ((sendTime = entity.getSendTime()) != null) {
            stmt.bindLong(2, sendTime.longValue());
        }
        if ((content = entity.getContent()) != null) {
            stmt.bindString(3, content);
        }
    }

    @Override
    protected LocalStateMsgDb readEntry(Cursor cursor, int offset) {
        LocalStateMsgDb entity = new LocalStateMsgDb(cursor.isNull(offset + 0) ? null : Long.valueOf(cursor.getLong(offset + 0)), cursor.isNull(offset + 1) ? null : Long.valueOf(cursor.getLong(offset + 1)), cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2));
        return entity;
    }
}

