/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.volley.toolbox;

import android.os.SystemClock;
import com.xdja.http.Header;
import com.xdja.http.HttpEntity;
import com.xdja.http.HttpResponse;
import com.xdja.http.StatusLine;
import com.xdja.http.conn.ConnectTimeoutException;
import com.xdja.http.util.EntityUtils;
import com.xdja.imsdk.volley.Cache;
import com.xdja.imsdk.volley.Network;
import com.xdja.imsdk.volley.NetworkResponse;
import com.xdja.imsdk.volley.Request;
import com.xdja.imsdk.volley.RetryPolicy;
import com.xdja.imsdk.volley.VolleyLog;
import com.xdja.imsdk.volley.error.AuthFailureError;
import com.xdja.imsdk.volley.error.CancelError;
import com.xdja.imsdk.volley.error.ServerError;
import com.xdja.imsdk.volley.error.TimeoutError;
import com.xdja.imsdk.volley.error.VolleyError;
import com.xdja.imsdk.volley.request.DownloadRequest;
import com.xdja.imsdk.volley.request.UploadRequest;
import com.xdja.imsdk.volley.stack.HttpStack;
import com.xdja.imsdk.volley.toolbox.ByteArrayPool;
import com.xdja.imsdk.volley.toolbox.PoolingByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.json.JSONException;
import org.json.JSONObject;

public class BasicNetwork
implements Network {
    private static int SLOW_REQUEST_THRESHOLD_MS = 3000;
    private static int REQUEST_DELAY_MS = 3000;
    private static int DEFAULT_POOL_SIZE = 4096;
    private static int DEFAULT_BUFFER_SIZE = 1024;
    protected final HttpStack mHttpStack;
    protected final ByteArrayPool mPool;

    public BasicNetwork(HttpStack httpStack) {
        this(httpStack, new ByteArrayPool(DEFAULT_POOL_SIZE));
    }

    public BasicNetwork(HttpStack httpStack, ByteArrayPool pool) {
        this.mHttpStack = httpStack;
        this.mPool = pool;
    }

    @Override
    public NetworkResponse performRequest(Request<?> request) throws VolleyError {
        long requestStart = SystemClock.elapsedRealtime();
        VolleyLog.d("start perform request (" + Thread.currentThread().getName() + ")", new Object[0]);
        while (true) {
            if (request.isCanceled()) {
                request.finish("perform-discard-cancelled");
                throw new CancelError("request is canceled.");
            }
            HttpResponse httpResponse = null;
            byte[] responseContents = null;
            Map<String, String> responseHeaders = Collections.emptyMap();
            long connectStartTime = SystemClock.elapsedRealtime();
            try {
                HashMap<String, String> headers = new HashMap<String, String>();
                httpResponse = this.mHttpStack.performRequest(request, headers);
                if (httpResponse == null) {
                    VolleyLog.e("performRequest finished, but exception.", new Object[0]);
                    throw new IOException();
                }
                VolleyLog.d("http performRequest finished(%d ms).", SystemClock.elapsedRealtime() - requestStart);
                request.onNetChange(40000, null);
                StatusLine statusLine = httpResponse.getStatusLine();
                int statusCode = statusLine.getStatusCode();
                VolleyLog.d("performRequest code %d for %s", statusCode, request.getUrl());
                responseHeaders = BasicNetwork.convertHeaders(httpResponse.getAllHeaders());
                if (statusCode == 304) {
                    Cache.Entry entry = request.getCacheEntry();
                    if (entry == null) {
                        NetworkResponse networkResponse = new NetworkResponse(304, null, responseHeaders, true, SystemClock.elapsedRealtime() - requestStart);
                        return networkResponse;
                    }
                    entry.responseHeaders.putAll(responseHeaders);
                    NetworkResponse networkResponse = new NetworkResponse(304, entry.data, entry.responseHeaders, true, SystemClock.elapsedRealtime() - requestStart);
                    return networkResponse;
                }
                if (httpResponse.getEntity() != null) {
                    if (request instanceof DownloadRequest) {
                        DownloadRequest downloadRequest = (DownloadRequest)request;
                        responseContents = downloadRequest.handleResponse(httpResponse);
                    } else if (request instanceof UploadRequest) {
                        UploadRequest uploadRequest = (UploadRequest)request;
                        responseContents = uploadRequest.handleResponse(httpResponse);
                    } else {
                        responseContents = this.entityToBytes(request, httpResponse.getEntity());
                    }
                } else {
                    responseContents = new byte[]{};
                }
                long requestLifetime = SystemClock.elapsedRealtime() - requestStart;
                this.logSlowRequests(requestLifetime, request, responseContents, statusLine);
                if (statusCode < 200 || statusCode > 299) {
                    throw new IOException();
                }
                VolleyLog.d("Handle Response finished.", new Object[0]);
                NetworkResponse networkResponse = new NetworkResponse(statusCode, responseContents, responseHeaders, false, SystemClock.elapsedRealtime() - requestStart);
                return networkResponse;
            }
            catch (SocketTimeoutException e) {
                VolleyLog.d("Request SocketTimeoutException:" + e.getMessage(), new Object[0]);
                request.onNetChange(40007, e.getMessage());
                BasicNetwork.attemptRetryOnException("socket", request, new TimeoutError(), SystemClock.elapsedRealtime() - connectStartTime);
                continue;
            }
            catch (ConnectTimeoutException e) {
                VolleyLog.d("Request ConnectTimeoutException:" + e.getMessage(), new Object[0]);
                request.onNetChange(40007, e.getMessage());
                BasicNetwork.attemptRetryOnException("connection", request, new TimeoutError(), SystemClock.elapsedRealtime() - connectStartTime);
                continue;
            }
            catch (MalformedURLException e) {
                BasicNetwork.attemptRetryOnException("connection", request, new TimeoutError(), SystemClock.elapsedRealtime() - connectStartTime);
                continue;
            }
            catch (IOException e) {
                int statusCode = 0;
                NetworkResponse networkResponse = null;
                if (httpResponse != null) {
                    statusCode = httpResponse.getStatusLine().getStatusCode();
                } else if (request.getRetryPolicy() != null && request.getRetryPolicy().getElapsedTimeTimeoutMs() > 10000) {
                    request.onNetChange(40004, e.getMessage());
                }
                VolleyLog.d("Unexpected response code %d for %s", statusCode, request.getUrl());
                long connectExpendTime = SystemClock.elapsedRealtime() - connectStartTime;
                if (connectExpendTime < (long)REQUEST_DELAY_MS) {
                    try {
                        Thread.sleep(REQUEST_DELAY_MS);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                }
                if (!(request instanceof DownloadRequest) && !(request instanceof UploadRequest)) {
                    if (statusCode == 400 || statusCode == 401) {
                        if (this.hasTicketError(responseContents)) {
                            networkResponse = new NetworkResponse(statusCode, responseContents, responseHeaders, false, SystemClock.elapsedRealtime() - requestStart);
                            throw new ServerError(networkResponse);
                        }
                    } else if (statusCode == 450) {
                        NetworkResponse networkResponse2 = new NetworkResponse(200, responseContents, responseHeaders, false, SystemClock.elapsedRealtime() - requestStart);
                        return networkResponse2;
                    }
                }
                if (responseContents != null) {
                    networkResponse = new NetworkResponse(statusCode, responseContents, responseHeaders, false, SystemClock.elapsedRealtime() - requestStart);
                    if (statusCode == 401 || statusCode == 403) {
                        BasicNetwork.attemptRetryOnException("auth", request, new AuthFailureError(networkResponse), SystemClock.elapsedRealtime() - connectStartTime);
                        continue;
                    }
                    BasicNetwork.attemptRetryOnException("connection", request, new ServerError(networkResponse), SystemClock.elapsedRealtime() - connectStartTime);
                    continue;
                }
                VolleyLog.d("Request NoConnectException:" + e.getMessage(), new Object[0]);
                BasicNetwork.attemptRetryOnException("connection", request, new VolleyError(e.getMessage()), SystemClock.elapsedRealtime() - connectStartTime);
                continue;
            }
            finally {
                try {
                    if (httpResponse == null) continue;
                    EntityUtils.consume(httpResponse.getEntity());
                }
                catch (IllegalStateException exception) {
                    exception.printStackTrace();
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
                continue;
            }
            break;
        }
    }

    private boolean hasTicketError(byte[] responseContents) {
        try {
            String content = new String(responseContents);
            VolleyLog.w("ERROR:" + content, new Object[0]);
            JSONObject object = new JSONObject(content);
            String errCode = object.optString("errCode");
            String message = object.optString("message");
            if ("0x9008".equals(errCode) && "ticket_is_invalid".equals(message)) {
                VolleyLog.e("ticket invalid ERROR!!", new Object[0]);
                return true;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return false;
    }

    private void logSlowRequests(long requestLifetime, Request<?> request, byte[] responseContents, StatusLine statusLine) {
        if (VolleyLog.DEBUG || requestLifetime > (long)SLOW_REQUEST_THRESHOLD_MS) {
            VolleyLog.d("HTTP response for request=<%s> [lifetime=%d], [size=%s], [rc=%d], [retryCount=%s]", request, requestLifetime, responseContents != null ? Integer.valueOf(responseContents.length) : "null", statusLine.getStatusCode(), request.getRetryPolicy().getCurrentRetryCount());
        }
    }

    private static void attemptRetryOnException(String logPrefix, Request<?> request, VolleyError exception, long connectExpendTime) throws VolleyError {
        RetryPolicy retryPolicy = request.getRetryPolicy();
        int oldTimeout = request.getTimeoutMs();
        try {
            VolleyLog.d("attempt retry request: " + request.toString(), new Object[0]);
            retryPolicy.retry(exception, connectExpendTime);
        }
        catch (VolleyError e) {
            request.onNetChange(40007, e.getMessage());
            request.addMarker(String.format("%s-timeout-giveup [timeout=%s]", logPrefix, oldTimeout));
            throw e;
        }
        request.addMarker(String.format("%s-retry [timeout=%s]", logPrefix, oldTimeout));
    }

    private byte[] entityToBytes(Request<?> request, HttpEntity entity) throws IOException, VolleyError {
        byte[] byArray;
        VolleyLog.d("entityToBytes request:" + request.toString(), new Object[0]);
        PoolingByteArrayOutputStream bytes = new PoolingByteArrayOutputStream(this.mPool, (int)entity.getContentLength());
        byte[] buffer = null;
        try {
            InputStream in = entity.getContent();
            if (in == null) {
                VolleyLog.d("InputStream is null.", new Object[0]);
                throw new IOException();
            }
            buffer = this.mPool.getBuf(DEFAULT_BUFFER_SIZE);
            long length = entity.getContentLength();
            long current = 0L;
            int count = -1;
            while ((count = in.read(buffer)) != -1) {
                if (count > 0 && bytes != null) {
                    bytes.write(buffer, 0, count);
                    current += (long)count;
                    if (length > 0L) {
                        request.deliverLoading(length, current);
                    } else {
                        request.deliverLoading(length == -1L ? current * 2L : length, current);
                    }
                }
                if (!request.isCanceled()) continue;
                VolleyLog.d("entityToBytes(request is canceled).", new Object[0]);
                request.finish("perform-discard-cancelled");
                throw new CancelError("request is canceled.");
            }
            VolleyLog.d("read data completed!!", new Object[0]);
            byArray = bytes.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                EntityUtils.consume(entity);
                this.mPool.returnBuf(buffer);
                bytes.close();
            }
            catch (IOException e) {
                VolleyLog.v("Error occured when calling consumingContent", new Object[0]);
            }
            throw throwable;
        }
        try {
            EntityUtils.consume(entity);
            this.mPool.returnBuf(buffer);
            bytes.close();
        }
        catch (IOException e) {
            VolleyLog.v("Error occured when calling consumingContent", new Object[0]);
        }
        return byArray;
    }

    protected static Map<String, String> convertHeaders(Header[] headers) {
        TreeMap<String, String> result = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        int i = 0;
        while (i < headers.length) {
            result.put(headers[i].getName(), headers[i].getValue());
            ++i;
        }
        return result;
    }
}

