/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.core.model.message;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.param.SessionParam;

public class TalkSessionBean
implements Comparable<TalkSessionBean> {
    private String talkFlag;
    private String talkerAccount;
    private long lastTime;
    private TalkMessageBean lastMsg;
    private String lastMsgAccount;
    private int lastMsgType;
    private CharSequence content;
    private int notReadCount;
    private int talkType = 0;
    private SessionParam param;

    public String getTalkFlag() {
        return this.talkFlag;
    }

    public void setTalkFlag(String talkFlag) {
        this.talkFlag = talkFlag;
        if (TextUtils.isEmpty((CharSequence)this.talkerAccount)) {
            this.decompose(talkFlag);
        }
    }

    public String getTalkerAccount() {
        return this.talkerAccount;
    }

    public void setTalkerAccount(String talkerAccount) {
        this.talkerAccount = talkerAccount;
    }

    public long getLastTime() {
        return this.lastTime;
    }

    public void setLastTime(long lastTime) {
        this.lastTime = lastTime;
    }

    public TalkMessageBean getLastMsg() {
        return this.lastMsg;
    }

    public void setLastMsg(TalkMessageBean lastMsg) {
        this.lastMsg = lastMsg;
    }

    public String getLastMsgAccount() {
        return this.lastMsgAccount;
    }

    public void setLastMsgAccount(String lastMsgAccount) {
        this.lastMsgAccount = lastMsgAccount;
    }

    public int getLastMsgType() {
        return this.lastMsgType;
    }

    public void setLastMsgType(int lastMsgType) {
        this.lastMsgType = lastMsgType;
    }

    public int getNotReadCount() {
        return this.notReadCount;
    }

    public void setNotReadCount(int notReadCount) {
        this.notReadCount = notReadCount;
    }

    public int getTalkType() {
        return this.talkType;
    }

    public void setTalkType(int talkType) {
        this.talkType = talkType;
    }

    public CharSequence getContent() {
        return this.content;
    }

    public void setContent(CharSequence content) {
        this.content = content;
    }

    public SessionParam getParam() {
        return this.param;
    }

    public void setParam(SessionParam param) {
        this.param = param;
    }

    public String toString() {
        return "TalkSessionBean{talkFlag='" + this.talkFlag + '\'' + ", talkerAccount='" + this.talkerAccount + '\'' + ", lastTime=" + this.lastTime + ", lastMsg=" + this.lastMsg + ", lastMsgAccount='" + this.lastMsgAccount + '\'' + ", lastMsgType=" + this.lastMsgType + ", content=" + this.content + ", notReadCount=" + this.notReadCount + ", talkType=" + this.talkType + ", param=" + this.param + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TalkSessionBean that = (TalkSessionBean)o;
        return this.talkFlag != null ? this.talkFlag.equals(that.talkFlag) : that.talkFlag == null;
    }

    public int hashCode() {
        return this.talkFlag != null ? this.talkFlag.hashCode() : 0;
    }

    @Override
    public int compareTo(@NonNull TalkSessionBean o) {
        if (this.param != null && o.param != null) {
            if (this.param.isTop() && !o.param.isTop()) {
                return -1;
            }
            if (!this.param.isTop() && o.param.isTop()) {
                return 1;
            }
            if (this.param.isTop() && o.param.isTop()) {
                if (this.param.getShowOnTopTime() == o.param.getShowOnTopTime()) {
                    return 0;
                }
                return this.param.getShowOnTopTime() > o.param.getShowOnTopTime() ? -1 : 1;
            }
        } else {
            if (this.param == null && o.param != null && o.param.isTop()) {
                return 1;
            }
            if (this.param != null && o.param == null && this.param.isTop()) {
                return -1;
            }
        }
        return o.getLastTime() > this.getLastTime() ? 1 : -1;
    }

    public void decompose(String sessionFlag) {
        if (TextUtils.isEmpty((CharSequence)sessionFlag)) {
            return;
        }
        String[] data = sessionFlag.split("_");
        this.talkerAccount = data[0];
        this.talkType = Integer.parseInt(data[1]);
    }
}

