/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.action.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.xdja.im.lib.action.bean.OptionBean;
import com.xdja.im.uikit.R;

public class ChatActionViewHolder
extends RecyclerView.ViewHolder {
    private View mItemView;
    private Context mContext;
    private ImageView iconImg;
    private TextView menuNameTv;

    public ChatActionViewHolder(Context context, View itemView) {
        super(itemView);
        this.mItemView = itemView;
        this.mContext = context;
        this.iconImg = (ImageView)itemView.findViewById(R.id.img_chat_menu);
        this.menuNameTv = (TextView)itemView.findViewById(R.id.tv_chat_menu);
    }

    public View getItemView() {
        return this.mItemView;
    }

    public void bindData(OptionBean optionBean) {
        try {
            this.iconImg.setImageResource(this.getImgRes(optionBean.getIcon()));
            this.menuNameTv.setText(this.getMenuName(optionBean.getLabel()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getImgRes(String resOps) {
        if (TextUtils.isEmpty((CharSequence)resOps)) {
            return -1;
        }
        String type = resOps.substring(resOps.indexOf(".") + 1, resOps.lastIndexOf("."));
        String name = resOps.substring(resOps.lastIndexOf(".") + 1);
        switch (type) {
            case "drawable": {
                return this.mContext.getResources().getIdentifier(name, "drawable", this.mContext.getPackageName());
            }
            case "mipmap": {
                return this.mContext.getResources().getIdentifier(name, "mipmap", this.mContext.getPackageName());
            }
        }
        return -1;
    }

    public int getMenuName(String resOps) {
        String name = resOps.substring(resOps.lastIndexOf(".") + 1);
        return this.mContext.getResources().getIdentifier(name, "string", this.mContext.getPackageName());
    }
}

