/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.xdja.im.common.utils.CommonTool;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class IntentParam {
    public static final String ACTION_CHAT = "action.xjda.im.uikit.chatlist";
    public static final String ACTION_CHAT_DEF = "action.xjda.im.uikit.chatlist.def";
    public static final String ACTION_USER_DETAIL = "action.xdja.im.uikit.user.detail";
    public static final String ACTION_GROUP_DETAIL = "action.xdja.im.uikit.group.detail";
    public static final String PARAM_CHAT = "Param_chatList";
    public static final String PARAM_SETTING = "Param_setting";
    public static final String PARAM_SESSION_ID = "talkerId";
    public static final String PARAM_SESSION_TYPE = "talkType";
    public static final String PARAM_ACCOUNT = "account";
    public static final int SESSION_TYPE_P2P = 1;
    public static final int SESSION_TYPE_P2G = 2;

    public static void startChatActivity(Context context, String sessionId, int sessionType) {
        Intent intent = new Intent();
        if (CommonTool.getPlatformType() == 1) {
            intent.setAction(ACTION_CHAT);
        } else {
            intent.setAction(context.getPackageName() + "." + ACTION_CHAT_DEF);
        }
        Bundle arguments = new Bundle();
        arguments.putString(PARAM_SESSION_ID, sessionId);
        arguments.putInt(PARAM_SESSION_TYPE, sessionType);
        intent.putExtras(arguments);
        intent.setPackage(context.getPackageName());
        context.startActivity(intent);
    }

    public static void startChatActivity(Context context, Bundle arguments) {
        Intent intent = new Intent();
        intent.setAction(ACTION_CHAT);
        intent.putExtra(PARAM_CHAT, arguments);
        intent.setPackage(context.getPackageName());
        context.startActivity(intent);
    }

    public static void startSettingActivity(Context context, String sessionId, int sessionType) {
        Intent intent = new Intent();
        if (sessionType == 1) {
            intent.setAction(ACTION_USER_DETAIL);
        } else {
            intent.setAction(ACTION_GROUP_DETAIL);
        }
        Bundle arguments = new Bundle();
        arguments.putString(PARAM_SESSION_ID, sessionId);
        arguments.putInt(PARAM_SESSION_TYPE, sessionType);
        intent.putExtra(PARAM_SETTING, arguments);
        intent.setPackage(context.getPackageName());
        context.startActivity(intent);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Session {
    }
}

