/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.base;

import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.ViewTreeObserver;
import com.xdja.im.base.di.component.DaggerUserComponent;
import com.xdja.im.base.di.component.RepositoryComponent;
import com.xdja.im.base.di.component.UserComponent;
import com.xdja.im.base.frame.BaseView;
import com.xdja.im.base.frame.Presenter;
import com.xdja.im.base.frame.presenter.BaseActivityPresenter;
import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.uikit.ImUiKit;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.ui.dialog.CustomDialog;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.utils.sys.NetworkUtil;

public abstract class ImBaseActivity<P extends Presenter, V extends BaseView>
extends BaseActivityPresenter<P, V> {
    protected UserComponent mComponent;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        this.setTheme(R.style.im_uikit_ImAppTheme);
        super.onCreate(savedInstanceState);
    }

    @Override
    protected void onBindView(@Nullable Bundle savedInstanceState) {
        super.onBindView(savedInstanceState);
        RepositoryComponent repositoryComponent = ImUiKit.getInstance().getComponent();
        if (repositoryComponent != null) {
            this.mComponent = DaggerUserComponent.builder().repositoryComponent(repositoryComponent).build();
        }
        if (this.mComponent == null) {
            LogUtil.e("Fatal :User component is null .");
            this.finish();
        }
        this.getWindow().getDecorView().getViewTreeObserver().addOnWindowFocusChangeListener(new ViewTreeObserver.OnWindowFocusChangeListener(){

            public void onWindowFocusChanged(boolean hasFocus) {
                ImBaseActivity.this.onActivityFocusChanged(hasFocus);
            }
        });
    }

    public void onConfigurationChanged(Configuration newConfig) {
        if (newConfig.fontScale != 1.0f) {
            this.getResources();
        }
        super.onConfigurationChanged(newConfig);
    }

    public Resources getResources() {
        boolean isChangeFontScale = CommonTool.isChangeFontScale();
        if (isChangeFontScale) {
            return super.getResources();
        }
        Resources resources = super.getResources();
        if (resources.getConfiguration().fontScale != 1.0f) {
            Configuration newConfig = new Configuration();
            newConfig.setToDefaults();
            resources.updateConfiguration(newConfig, resources.getDisplayMetrics());
        }
        return resources;
    }

    protected void showMissingPermissionDialog() {
        new CustomDialog(this.getContext(), new CustomDialog.OnCloseListener(){

            @Override
            public void onClick(Dialog dialog, boolean confirm) {
                if (confirm) {
                    ImBaseActivity.this.startAppSettings();
                } else {
                    ImBaseActivity.this.finish();
                }
            }
        }).setDialogTitle(R.string.im_uikit_hint).setDialogContent(R.string.im_uikit_permission_hint).setPositiveButton(R.string.im_uikit_setting).setNegativeButton(R.string.im_uikit_btn_cancel).show();
    }

    private void startAppSettings() {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(Uri.parse((String)("package:" + this.getPackageName())));
        this.startActivity(intent);
    }

    protected void checkNetType(final OnNetCheckCallback result) {
        boolean isMobileConnected = NetworkUtil.isConnectByMobile(this.getContext());
        if (isMobileConnected) {
            new CustomDialog(this.getContext(), new CustomDialog.OnCloseListener(){

                @Override
                public void onClick(Dialog dialog, boolean confirm) {
                    result.onResult(!confirm);
                }
            }).setDialogTitle(result.getTitle()).setDialogContent(result.getContent()).setPositiveButton(result.getPositiveButton()).setNegativeButton(result.getNegativeButton()).show();
        } else {
            result.onResult(false);
        }
    }

    protected Context getContext() {
        return this;
    }

    protected void onDestroy() {
        super.onDestroy();
    }

    protected void onActivityFocusChanged(boolean hasFocus) {
    }

    protected void showToast(String content) {
        CommonTool.showToast(content);
    }

    protected void showToast(int resId) {
        CommonTool.showToast(resId);
    }

    public abstract class OnNetCheckCallback {
        public abstract void onResult(boolean var1);

        protected String getContent() {
            return "";
        }

        protected String getTitle() {
            return ImBaseActivity.this.getString(R.string.im_uikit_hint);
        }

        protected String getPositiveButton() {
            return ImBaseActivity.this.getString(R.string.im_uikit_btn_continue);
        }

        protected String getNegativeButton() {
            return ImBaseActivity.this.getString(R.string.im_uikit_btn_cancel);
        }
    }
}

