/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.view;

import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.xdja.im.base.frame.view.FragmentSuperBaseView;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.action.options.ImOption;
import com.xdja.im.uikit.ui.adapter.SessionListAdapter;
import com.xdja.im.uikit.ui.dialog.BaseListDialog;
import com.xdja.im.uikit.ui.presenter.SessionListPresenter;
import com.xdja.im.uikit.ui.view.vu.SessionListVu;
import java.util.ArrayList;
import java.util.List;

public class ViewSessionList
extends FragmentSuperBaseView<SessionListPresenter>
implements SessionListVu {
    private ListView mChatSessionList;
    private ProgressBar mLoadingPBar;
    private TextView mEmptyHintTv;
    private BaseListDialog mPopDialog;
    protected List<ImOption> mImOptions = new ArrayList<ImOption>();

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_fragment_session_list;
    }

    @Override
    protected void injectView() {
        super.injectView();
        this.mChatSessionList = (ListView)this.findViewById(R.id.rv_session_list);
        this.mLoadingPBar = (ProgressBar)this.findViewById(R.id.pbar_loading);
        this.mEmptyHintTv = (TextView)this.findViewById(R.id.tv_empty);
        this.mChatSessionList.setEmptyView((View)this.mEmptyHintTv);
        this.mPopDialog = new BaseListDialog(this.getContext()){

            @Override
            public List<ImOption> getOptions() {
                return ViewSessionList.this.buildImOptions();
            }
        };
        this.setListener();
    }

    private void setListener() {
        this.mChatSessionList.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                ((SessionListPresenter)ViewSessionList.this.getPresenter()).onListItemClick(position);
            }
        });
        this.mChatSessionList.setOnItemLongClickListener(new AdapterView.OnItemLongClickListener(){

            public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id2) {
                return ViewSessionList.this.showPopDialog(position);
            }
        });
        this.mPopDialog.setOnItemClickListener(new BaseListDialog.onItemClickListener(){

            @Override
            public void onItemClick(View view, ImOption option, int itemPosition) {
                ViewSessionList.this.dismissPopDialog();
                switch (option.getOptionType()) {
                    case 1: {
                        ((SessionListPresenter)ViewSessionList.this.getPresenter()).deleteSession(itemPosition);
                        break;
                    }
                    case 2: 
                    case 3: {
                        ((SessionListPresenter)ViewSessionList.this.getPresenter()).setSessionTop(itemPosition);
                        break;
                    }
                    case 4: 
                    case 5: {
                        ((SessionListPresenter)ViewSessionList.this.getPresenter()).setDisturb(itemPosition);
                    }
                }
            }
        });
    }

    @Override
    public void setAdapter(SessionListAdapter adapter) {
        this.mChatSessionList.setAdapter((ListAdapter)adapter);
        this.mEmptyHintTv.setVisibility(8);
    }

    @Override
    public void setProgressBarVisibility(int visibility) {
        this.mLoadingPBar.setVisibility(visibility);
    }

    private List<ImOption> buildImOptions() {
        this.mImOptions.add(new ImOption(1, this.getStringRes(R.string.im_uikit_session_option_delete)));
        this.mImOptions.add(new ImOption(2, this.getStringRes(R.string.im_uikit_session_option_settop)));
        this.mImOptions.add(new ImOption(3, this.getStringRes(R.string.im_uikit_session_option_canceltop)));
        this.mImOptions.add(new ImOption(4, this.getStringRes(R.string.im_uikit_session_option_opendisturb)));
        this.mImOptions.add(new ImOption(5, this.getStringRes(R.string.im_uikit_session_option_closedisturb)));
        return this.mImOptions;
    }

    private boolean showPopDialog(int position) {
        ArrayList<ImOption> data = new ArrayList<ImOption>();
        data.add(this.mImOptions.get(0));
        if (!((SessionListPresenter)this.getPresenter()).isSessionTop(position)) {
            data.add(this.mImOptions.get(1));
        } else {
            data.add(this.mImOptions.get(2));
        }
        this.mPopDialog.addData(data);
        this.mPopDialog.show(position);
        return true;
    }

    protected void dismissPopDialog() {
        if (this.mPopDialog != null) {
            this.mPopDialog.dismiss();
        }
    }
}

