/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.utils.sys;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

public class NetworkUtil {
    public static final int NO_CONNECT = -1;
    public static final int NET_TYPE_WIFI = 1;
    public static final int NET_TYPE_MOBILE = 2;

    public static boolean isNetworkConnected(Context context) {
        ConnectivityManager mConnectivityManager;
        NetworkInfo mNetworkInfo;
        if (context != null && (mNetworkInfo = (mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo()) != null) {
            return mNetworkInfo.isAvailable();
        }
        return false;
    }

    public static boolean isWifiConnected(Context context) {
        ConnectivityManager mConnectivityManager;
        NetworkInfo mWiFiNetworkInfo;
        if (context != null && (mWiFiNetworkInfo = (mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity")).getNetworkInfo(1)) != null) {
            return mWiFiNetworkInfo.isAvailable();
        }
        return false;
    }

    public static boolean isMobileConnected(Context context) {
        ConnectivityManager mConnectivityManager;
        NetworkInfo mMobileNetworkInfo;
        if (context != null && (mMobileNetworkInfo = (mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity")).getNetworkInfo(0)) != null) {
            return mMobileNetworkInfo.isAvailable();
        }
        return false;
    }

    public static int GetNetworkType(Context context) {
        int netType = -1;
        ConnectivityManager connMgr = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connMgr.getActiveNetworkInfo();
        if (networkInfo == null) {
            return netType;
        }
        int nType = networkInfo.getType();
        if (nType == 0) {
            netType = 2;
        } else if (nType == 1) {
            netType = 1;
        }
        return netType;
    }

    public static boolean isConnectByWifi(Context context) {
        return NetworkUtil.GetNetworkType(context) == 1;
    }

    public static boolean isConnectByMobile(Context context) {
        return NetworkUtil.GetNetworkType(context) == 2;
    }
}

