/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.http.client.protocol;

import com.xdja.http.HttpException;
import com.xdja.http.HttpRequest;
import com.xdja.http.HttpRequestInterceptor;
import com.xdja.http.annotation.Immutable;
import com.xdja.http.client.protocol.HttpClientContext;
import com.xdja.http.conn.routing.RouteInfo;
import com.xdja.http.protocol.HttpContext;
import com.xdja.http.util.Args;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Immutable
public class RequestClientConnControl
implements HttpRequestInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String PROXY_CONN_DIRECTIVE = "Proxy-Connection";

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            request.setHeader(PROXY_CONN_DIRECTIVE, "Keep-Alive");
            return;
        }
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RouteInfo route = clientContext.getHttpRoute();
        if (route == null) {
            this.log.debug((Object)"Connection route not set in the context");
            return;
        }
        if ((route.getHopCount() == 1 || route.isTunnelled()) && !request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
        if (route.getHopCount() == 2 && !route.isTunnelled() && !request.containsHeader(PROXY_CONN_DIRECTIVE)) {
            request.addHeader(PROXY_CONN_DIRECTIVE, "Keep-Alive");
        }
    }
}

