/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.http.impl.auth;

import com.xdja.http.annotation.Immutable;
import com.xdja.http.auth.AuthScheme;
import com.xdja.http.auth.AuthSchemeFactory;
import com.xdja.http.auth.AuthSchemeProvider;
import com.xdja.http.impl.auth.KerberosScheme;
import com.xdja.http.params.HttpParams;
import com.xdja.http.protocol.HttpContext;

@Immutable
public class KerberosSchemeFactory
implements AuthSchemeFactory,
AuthSchemeProvider {
    private final boolean stripPort;
    private final boolean useCanonicalHostname;

    public KerberosSchemeFactory(boolean stripPort, boolean useCanonicalHostname) {
        this.stripPort = stripPort;
        this.useCanonicalHostname = useCanonicalHostname;
    }

    public KerberosSchemeFactory(boolean stripPort) {
        this.stripPort = stripPort;
        this.useCanonicalHostname = true;
    }

    public KerberosSchemeFactory() {
        this(true, true);
    }

    public boolean isStripPort() {
        return this.stripPort;
    }

    public boolean isUseCanonicalHostname() {
        return this.useCanonicalHostname;
    }

    @Override
    public AuthScheme newInstance(HttpParams params) {
        return new KerberosScheme(this.stripPort, this.useCanonicalHostname);
    }

    @Override
    public AuthScheme create(HttpContext context) {
        return new KerberosScheme(this.stripPort, this.useCanonicalHostname);
    }
}

