/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.common.database.helper;

import android.text.TextUtils;
import com.xdja.im.common.database.bean.SessionDb;
import com.xdja.im.common.database.dao.SessionEntityDao;
import com.xdja.im.core.model.param.SessionParam;
import java.util.ArrayList;
import java.util.List;

public class MXSettingHelper {
    public static boolean setSessionTop(String sessionFlag, boolean isTop) {
        SessionDb sessionDb = SessionEntityDao.getInstance().get(sessionFlag);
        if (sessionDb == null && isTop) {
            sessionDb = new SessionDb();
            sessionDb.setSessionFlag(sessionFlag);
            sessionDb.setSessionMode(isTop ? 1 : 0);
            sessionDb.setDraftContent("");
            sessionDb.setDraftCreateTime(0L);
            SessionEntityDao.getInstance().insert(sessionDb);
        } else {
            sessionDb.setSessionMode(isTop ? 1 : 0);
            if (TextUtils.isEmpty((CharSequence)sessionDb.getDraftContent())) {
                sessionDb.setDraftContent("");
            }
            SessionEntityDao.getInstance().update(sessionDb);
        }
        return true;
    }

    public static boolean setSessionDisturb(String sessionFlag, boolean isDisturb) {
        SessionDb sessionDb = SessionEntityDao.getInstance().get(sessionFlag);
        if (sessionDb == null && isDisturb) {
            sessionDb = new SessionDb();
            sessionDb.setSessionFlag(sessionFlag);
            sessionDb.setSessionDisturb(isDisturb ? 1 : 0);
            sessionDb.setDraftContent("");
            sessionDb.setDraftCreateTime(0L);
            SessionEntityDao.getInstance().insert(sessionDb);
        } else {
            sessionDb.setSessionDisturb(isDisturb ? 1 : 0);
            if (TextUtils.isEmpty((CharSequence)sessionDb.getDraftContent())) {
                sessionDb.setDraftContent("");
            }
            SessionEntityDao.getInstance().update(sessionDb);
        }
        return true;
    }

    public static boolean setReceiveMode(String sessionFlag, boolean isOpen) {
        SessionDb sessionDb = SessionEntityDao.getInstance().get(sessionFlag);
        if (sessionDb == null && isOpen) {
            sessionDb = new SessionDb();
            sessionDb.setSessionFlag(sessionFlag);
            sessionDb.setReceiveMode(isOpen ? 1 : 0);
            sessionDb.setDraftContent("");
            sessionDb.setDraftCreateTime(0L);
            SessionEntityDao.getInstance().insert(sessionDb);
        } else {
            sessionDb.setReceiveMode(isOpen ? 1 : 0);
            if (TextUtils.isEmpty((CharSequence)sessionDb.getDraftContent())) {
                sessionDb.setDraftContent("");
            }
            SessionEntityDao.getInstance().update(sessionDb);
        }
        return true;
    }

    public static boolean isSessionDisturb(String sessionFlag) {
        SessionDb sessionDb = SessionEntityDao.getInstance().get(sessionFlag);
        if (sessionDb != null) {
            return sessionDb.getSessionDisturb() == 1;
        }
        return false;
    }

    public static boolean insertDraft(String sessionFlag, String draftContent, long draftTime) {
        SessionDb sessionDb = SessionEntityDao.getInstance().get(sessionFlag);
        if (sessionDb == null) {
            sessionDb = new SessionDb();
            sessionDb.setSessionFlag(sessionFlag);
            sessionDb.setDraftContent(draftContent);
            sessionDb.setDraftCreateTime(draftTime);
            SessionEntityDao.getInstance().insert(sessionDb);
        } else {
            sessionDb.setDraftContent(draftContent);
            if (draftTime > 0L) {
                sessionDb.setDraftCreateTime(draftTime);
            }
            SessionEntityDao.getInstance().update(sessionDb);
        }
        return true;
    }

    public static boolean clearDraft(String sessionFlag, long draftTime) {
        SessionDb sessionDb = SessionEntityDao.getInstance().get(sessionFlag);
        if (sessionDb != null) {
            sessionDb.setDraftContent("");
            if (draftTime > 0L) {
                sessionDb.setDraftCreateTime(draftTime);
            }
            SessionEntityDao.getInstance().update(sessionDb);
        }
        return true;
    }

    public static String getDraftContent(String sessionFlag) {
        SessionDb sessionDb = SessionEntityDao.getInstance().get(sessionFlag);
        if (sessionDb != null) {
            return sessionDb.getDraftContent();
        }
        return "";
    }

    public static boolean isHasDraft(String sessionFlag) {
        SessionDb sessionDb = SessionEntityDao.getInstance().get(sessionFlag);
        if (sessionDb != null) {
            return sessionDb.getDraftContent() != null && sessionDb.getDraftCreateTime() > 0L;
        }
        return false;
    }

    public static SessionParam getSessionParam(String sessionFlag) {
        SessionParam param = new SessionParam();
        SessionDb db = SessionEntityDao.getInstance().get(sessionFlag);
        if (db != null) {
            param.setSessionFlag(db.getSessionFlag());
            param.setTop(db.getSessionMode() == 1);
            param.setDisturb(db.getSessionDisturb() == 1);
            param.setReceiveMode(db.getReceiveMode() == 1);
            param.setDraftContent(db.getDraftContent());
            param.setDraftTime(db.getDraftCreateTime());
        }
        return param;
    }

    public static List<SessionParam> getAllSessionParams() {
        ArrayList<SessionParam> sessionParams = new ArrayList<SessionParam>();
        List<SessionDb> sessionDbs = SessionEntityDao.getInstance().getAll();
        for (SessionDb db : sessionDbs) {
            SessionParam param = new SessionParam();
            param.setSessionFlag(db.getSessionFlag());
            param.setTop(db.getSessionMode() == 1);
            param.setDisturb(db.getSessionDisturb() == 1);
            param.setReceiveMode(db.getReceiveMode() == 1);
            param.setDraftContent(db.getDraftContent());
            param.setDraftTime(db.getDraftCreateTime());
            sessionParams.add(param);
        }
        return sessionParams;
    }

    public static boolean deleteSessionParam(String sessionFlag) {
        return SessionEntityDao.getInstance().delete(sessionFlag) >= 0;
    }

    public static void deleteOnlyDraft(String sessionFlag) {
        SessionEntityDao.getInstance().deleteOnlyDraft(sessionFlag);
    }

    public static boolean deleteAllSessionParams() {
        return SessionEntityDao.getInstance().deleteAll() >= 0;
    }
}

