/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.common.permission;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.support.annotation.StringRes;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AlertDialog;
import android.util.Log;
import com.xdja.im.common.permission.AfterPermissionGranted;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class KitPermissions {
    private static final String TAG = "KitPermissions";

    public static boolean hasPermissions(Context context, String ... perms) {
        if (Build.VERSION.SDK_INT < 23) {
            Log.w((String)TAG, (String)"hasPermissions: API version < M, returning true by default");
            return true;
        }
        for (String perm : perms) {
            boolean hasPerm;
            boolean bl = hasPerm = ContextCompat.checkSelfPermission((Context)context, (String)perm) == 0;
            if (hasPerm) continue;
            return false;
        }
        return true;
    }

    public static void requestPermissions(Object object, String rationale, int requestCode, String ... perms) {
        KitPermissions.requestPermissions(object, rationale, 17039370, 0x1040000, requestCode, perms);
    }

    public static void requestPermissions(final Object object, String rationale, @StringRes int positiveButton, @StringRes int negativeButton, final int requestCode, final String ... perms) {
        KitPermissions.checkCallingObjectSuitability(object);
        boolean shouldShowRationale = false;
        for (String perm : perms) {
            shouldShowRationale = shouldShowRationale || KitPermissions.shouldShowRequestPermissionRationale(object, perm);
        }
        if (shouldShowRationale) {
            Activity activity = KitPermissions.getActivity(object);
            if (null == activity) {
                return;
            }
            AlertDialog dialog = new AlertDialog.Builder((Context)activity).setMessage((CharSequence)rationale).setPositiveButton(positiveButton, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    KitPermissions.executePermissionsRequest(object, perms, requestCode);
                }
            }).setNegativeButton(negativeButton, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (object instanceof PermissionCallbacks) {
                        ((PermissionCallbacks)object).onPermissionsDenied(requestCode, Arrays.asList(perms));
                    }
                }
            }).create();
            dialog.show();
        } else {
            KitPermissions.executePermissionsRequest(object, perms, requestCode);
        }
    }

    public static boolean somePermissionPermanentlyDenied(Object object, List<String> deniedPermissions) {
        for (String deniedPermission : deniedPermissions) {
            if (!KitPermissions.permissionPermanentlyDenied(object, deniedPermission)) continue;
            return true;
        }
        return false;
    }

    public static boolean permissionPermanentlyDenied(Object object, String deniedPermission) {
        return !KitPermissions.shouldShowRequestPermissionRationale(object, deniedPermission);
    }

    public static void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults, Object object) {
        KitPermissions.checkCallingObjectSuitability(object);
        ArrayList<String> granted = new ArrayList<String>();
        ArrayList<String> denied = new ArrayList<String>();
        for (int i = 0; i < permissions.length; ++i) {
            String perm = permissions[i];
            if (grantResults[i] == 0) {
                granted.add(perm);
                continue;
            }
            denied.add(perm);
        }
        if (!granted.isEmpty() && object instanceof PermissionCallbacks) {
            ((PermissionCallbacks)object).onPermissionsGranted(requestCode, granted);
        }
        if (!denied.isEmpty() && object instanceof PermissionCallbacks) {
            ((PermissionCallbacks)object).onPermissionsDenied(requestCode, denied);
        }
        if (!granted.isEmpty() && denied.isEmpty()) {
            KitPermissions.runAnnotatedMethods(object, requestCode);
        }
    }

    @TargetApi(value=23)
    private static boolean shouldShowRequestPermissionRationale(Object object, String perm) {
        if (object instanceof Activity) {
            return ActivityCompat.shouldShowRequestPermissionRationale((Activity)((Activity)object), (String)perm);
        }
        if (object instanceof android.support.v4.app.Fragment) {
            return ((android.support.v4.app.Fragment)object).shouldShowRequestPermissionRationale(perm);
        }
        if (object instanceof Fragment) {
            return ((Fragment)object).shouldShowRequestPermissionRationale(perm);
        }
        return false;
    }

    @TargetApi(value=23)
    private static void executePermissionsRequest(Object object, String[] perms, int requestCode) {
        KitPermissions.checkCallingObjectSuitability(object);
        if (object instanceof Activity) {
            ActivityCompat.requestPermissions((Activity)((Activity)object), (String[])perms, (int)requestCode);
        } else if (object instanceof android.support.v4.app.Fragment) {
            ((android.support.v4.app.Fragment)object).requestPermissions(perms, requestCode);
        } else if (object instanceof Fragment) {
            ((Fragment)object).requestPermissions(perms, requestCode);
        }
    }

    @TargetApi(value=11)
    private static Activity getActivity(Object object) {
        if (object instanceof Activity) {
            return (Activity)object;
        }
        if (object instanceof android.support.v4.app.Fragment) {
            return ((android.support.v4.app.Fragment)object).getActivity();
        }
        if (object instanceof Fragment) {
            return ((Fragment)object).getActivity();
        }
        return null;
    }

    private static void runAnnotatedMethods(Object object, int requestCode) {
        Class<?> clazz = object.getClass();
        if (KitPermissions.isUsingAndroidAnnotations(object)) {
            clazz = clazz.getSuperclass();
        }
        for (Method method : clazz.getDeclaredMethods()) {
            AfterPermissionGranted ann;
            if (!method.isAnnotationPresent(AfterPermissionGranted.class) || (ann = method.getAnnotation(AfterPermissionGranted.class)).value() != requestCode) continue;
            if (method.getParameterTypes().length > 0) {
                throw new RuntimeException("Cannot execute non-void method " + method.getName());
            }
            try {
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                method.invoke(object, new Object[0]);
            }
            catch (IllegalAccessException e) {
                Log.e((String)TAG, (String)"runDefaultMethod:IllegalAccessException", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                Log.e((String)TAG, (String)"runDefaultMethod:InvocationTargetException", (Throwable)e);
            }
        }
    }

    private static void checkCallingObjectSuitability(Object object) {
        boolean isMinSdkM;
        boolean isActivity = object instanceof Activity;
        boolean isSupportFragment = object instanceof android.support.v4.app.Fragment;
        boolean isAppFragment = object instanceof Fragment;
        boolean bl = isMinSdkM = Build.VERSION.SDK_INT >= 23;
        if (!(isSupportFragment || isActivity || isAppFragment && isMinSdkM)) {
            if (isAppFragment) {
                throw new IllegalArgumentException("Target SDK needs to be greater than 23 if caller is android.app.Fragment");
            }
            throw new IllegalArgumentException("Caller must be an Activity or a Fragment.");
        }
    }

    private static boolean isUsingAndroidAnnotations(Object object) {
        if (!object.getClass().getSimpleName().endsWith("_")) {
            return false;
        }
        try {
            Class<?> clazz = Class.forName("org.androidannotations.api.view.HasViews");
            return clazz.isInstance(object);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static interface PermissionCallbacks
    extends ActivityCompat.OnRequestPermissionsResultCallback {
        public void onPermissionsGranted(int var1, List<String> var2);

        public void onPermissionsDenied(int var1, List<String> var2);
    }
}

