/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.core.proxy;

import android.text.TextUtils;
import com.xdja.im.base.eventbus.BusProvider;
import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.model.account.ActionDesc;
import com.xdja.im.core.model.account.GroupAction;
import com.xdja.im.core.model.event.IMContactEvent;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.proxy.ImUiKitContactProxy;
import com.xdja.im.core.utils.DataCache;
import com.xdja.im.core.utils.ToolUtils;
import com.xdja.im.uikit.ImUiKit;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.log.LogUtil;
import java.util.List;
import rx.Subscriber;

public class ImUiKitContactProxyImpl
implements ImUiKitContactProxy {
    private String mCurAccount = ImUiKit.getInstance().getCurAccount();

    public static ImUiKitContactProxyImpl getInstance() {
        return SingletonInstance.mInstance;
    }

    private ImUiKitContactProxyImpl() {
    }

    @Override
    public void notifyGroupChanged(String groupId, GroupAction action, ActionDesc actionDesc) {
        switch (action) {
            case ACTION_ADD: {
                this.onAddMemberAction(groupId, actionDesc);
                break;
            }
            case ACTION_REMOVE: {
                this.onRemoveMemberAction(groupId, actionDesc);
                break;
            }
            case ACTION_CREATE: {
                this.onCreateGroupAction(groupId, actionDesc);
                break;
            }
            case ACTION_UPDATE: {
                this.onGroupUpdateAction(groupId, actionDesc);
                break;
            }
            case ACTION_DISSOLUTION: {
                this.onDissolutionAction(groupId, actionDesc);
                break;
            }
            case ACTION_QUIT: {
                this.onQuitAction(groupId, actionDesc);
            }
        }
    }

    private String getGroupFlag(String groupId) {
        return ToolUtils.getSessionTag(groupId, 2);
    }

    private void onAddMemberAction(String groupId, ActionDesc actionDesc) {
        String content = actionDesc.getMessage();
        if (TextUtils.isEmpty((CharSequence)content)) {
            content = this.buildAddMemberMessage(actionDesc.getMaster(), actionDesc.getAccountList());
        }
        this.sendNotifyMessage(groupId, content);
    }

    private void onRemoveMemberAction(String groupId, ActionDesc actionDesc) {
        String content = actionDesc.getMessage();
        if (TextUtils.isEmpty((CharSequence)content)) {
            content = this.buildRemoveMemberNotifyContent(actionDesc.getMaster(), actionDesc.getAccountList());
        }
        this.sendNotifyMessage(groupId, content);
    }

    private void onCreateGroupAction(String groupId, ActionDesc actionDesc) {
        String content = actionDesc.getMessage();
        if (TextUtils.isEmpty((CharSequence)content)) {
            content = this.buildCreateGroupMessage(actionDesc.getMaster(), actionDesc.getAccountList());
        }
        DataCache.getInstance().remove(this.getGroupFlag(groupId));
        IMContactEvent.RefreshGroupEvent refreshGroupEvent = new IMContactEvent.RefreshGroupEvent();
        refreshGroupEvent.setAccount(groupId);
        BusProvider.getInstance().post(refreshGroupEvent);
        this.sendNotifyMessage(groupId, content);
    }

    private void onGroupUpdateAction(String groupId, ActionDesc actionDesc) {
        String content = actionDesc.getMessage();
        if (!TextUtils.isEmpty((CharSequence)content)) {
            this.sendNotifyMessage(groupId, content);
        }
        DataCache.getInstance().remove(this.getGroupFlag(groupId));
        IMContactEvent.RefreshGroupEvent refreshGroupEvent = new IMContactEvent.RefreshGroupEvent();
        refreshGroupEvent.setAccount(groupId);
        BusProvider.getInstance().post(refreshGroupEvent);
    }

    private void onDissolutionAction(String groupId, ActionDesc actionDesc) {
        AccountBean master;
        String content = actionDesc.getMessage();
        if (TextUtils.isEmpty((CharSequence)content)) {
            content = this.buildDissolutionNotifyContent(actionDesc.getMaster(), actionDesc.getAccountList());
        }
        if (TextUtils.equals((CharSequence)this.mCurAccount, (CharSequence)(master = actionDesc.getMaster()).getAccount())) {
            DataCache.getInstance().remove(this.getGroupFlag(groupId));
            IMContactEvent.DissolutionGroupEvent dissolutionGroupEvent = new IMContactEvent.DissolutionGroupEvent();
            dissolutionGroupEvent.setAccount(groupId);
            BusProvider.getInstance().post(dissolutionGroupEvent);
        } else {
            this.sendNotifyMessage(groupId, content);
        }
    }

    private void onQuitAction(String groupId, ActionDesc actionDesc) {
        AccountBean master;
        String content = actionDesc.getMessage();
        if (TextUtils.isEmpty((CharSequence)content)) {
            content = this.buildQuitMessage(actionDesc.getMaster(), actionDesc.getAccountList());
        }
        if (TextUtils.equals((CharSequence)this.mCurAccount, (CharSequence)(master = actionDesc.getMaster()).getAccount())) {
            DataCache.getInstance().remove(this.getGroupFlag(groupId));
            IMContactEvent.DissolutionGroupEvent dissolutionGroupEvent = new IMContactEvent.DissolutionGroupEvent();
            dissolutionGroupEvent.setAccount(groupId);
            BusProvider.getInstance().post(dissolutionGroupEvent);
        } else {
            this.sendNotifyMessage(groupId, content);
        }
    }

    private void sendNotifyMessage(String to, String message) {
        TalkMessageBean talkMessageBean = new TalkMessageBean();
        talkMessageBean.setTo(to);
        talkMessageBean.setGroupMsg(true);
        talkMessageBean.setMessageType(101);
        talkMessageBean.setContent(message);
        ImUiKit.getInstance().getComponent().proxyRepository().sendCustomMessage(talkMessageBean, new Subscriber<TalkMessageBean>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.e("ERROR:Create group and send custom message failed.");
            }

            public void onNext(TalkMessageBean talkMessageBean) {
                LogUtil.d("Create group and send custom message successfully.");
            }
        });
    }

    private String buildAddMemberListMessage(AccountBean master, List<AccountBean> memberList) {
        int size = memberList.size();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < size - 1; ++i) {
            AccountBean member = memberList.get(i);
            if (TextUtils.equals((CharSequence)this.mCurAccount, (CharSequence)member.getAccount())) continue;
            builder.append(memberList.get(i).getDisplayName()).append("\u3001");
        }
        builder.append(memberList.get(size - 1).getDisplayName());
        return String.format(CommonTool.getString(R.string.im_uikit_add_member1), builder.toString());
    }

    private String buildRemoveMemberListMessage(AccountBean master, List<AccountBean> memberList) {
        int size = memberList.size();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < size - 1; ++i) {
            AccountBean member = memberList.get(i);
            if (TextUtils.equals((CharSequence)this.mCurAccount, (CharSequence)member.getAccount())) continue;
            builder.append(memberList.get(i).getDisplayName()).append("\u3001");
        }
        builder.append(memberList.get(size - 1).getDisplayName());
        return String.format(CommonTool.getString(R.string.im_uikit_remove_member1), builder.toString());
    }

    private String buildCreateGroupMessage(AccountBean master, List<AccountBean> memberList) {
        if (TextUtils.equals((CharSequence)this.mCurAccount, (CharSequence)master.getAccount())) {
            return this.buildAddMemberListMessage(master, memberList);
        }
        return String.format(CommonTool.getString(R.string.im_uikit_add_member2), master.getDisplayName());
    }

    private String buildAddMemberMessage(AccountBean master, List<AccountBean> memberList) {
        boolean isCurMaster = TextUtils.equals((CharSequence)this.mCurAccount, (CharSequence)master.getAccount());
        if (isCurMaster) {
            return this.buildAddMemberListMessage(master, memberList);
        }
        String memberListName = "";
        AccountBean memberBean = memberList.get(0);
        StringBuffer sbMemberName = new StringBuffer();
        int memberListsize = memberList.size();
        if (memberListsize < 0) {
            LogUtil.d("MemberListSiez is Error");
            return "";
        }
        if (memberListsize >= 1) {
            for (int i = 0; i < memberListsize; ++i) {
                memberBean = memberList.get(i);
                if (memberBean.getAccount().equals(master.getAccount())) continue;
                memberListName = this.getMemberListName(master, memberBean);
                sbMemberName = sbMemberName.append(memberListName + ",");
            }
        }
        LogUtil.d("buildAddMemberMessage == " + sbMemberName);
        return sbMemberName.toString();
    }

    private String getMemberListName(AccountBean master, AccountBean memberBean) {
        if (TextUtils.equals((CharSequence)this.mCurAccount, (CharSequence)memberBean.getAccount())) {
            return String.format(CommonTool.getString(R.string.im_uikit_add_member2), master.getDisplayName());
        }
        return String.format(CommonTool.getString(R.string.im_uikit_add_member3), master.getDisplayName(), memberBean.getDisplayName());
    }

    private String buildRemoveMemberNotifyContent(AccountBean master, List<AccountBean> memberList) {
        if (TextUtils.equals((CharSequence)this.mCurAccount, (CharSequence)master.getAccount())) {
            return this.buildRemoveMemberListMessage(master, memberList);
        }
        AccountBean operator = memberList.get(0);
        if (TextUtils.equals((CharSequence)this.mCurAccount, (CharSequence)operator.getAccount())) {
            return String.format(CommonTool.getString(R.string.im_uikit_remove_member2), master.getDisplayName());
        }
        return String.format(CommonTool.getString(R.string.im_uikit_remove_member3), operator.getDisplayName(), master.getDisplayName());
    }

    private String buildDissolutionNotifyContent(AccountBean master, List<AccountBean> accountList) {
        if (TextUtils.equals((CharSequence)this.mCurAccount, (CharSequence)master.getAccount())) {
            return CommonTool.getString(R.string.im_uikit_dissolution1);
        }
        return String.format(CommonTool.getString(R.string.im_uikit_dissolution2), master.getDisplayName());
    }

    private String buildQuitMessage(AccountBean master, List<AccountBean> accountList) {
        if (TextUtils.equals((CharSequence)this.mCurAccount, (CharSequence)master.getAccount())) {
            return CommonTool.getString(R.string.im_uikit_quit_group);
        }
        AccountBean opetator = accountList.get(0);
        return String.format(CommonTool.getString(R.string.im_uikit_quit_group2), opetator.getDisplayName());
    }

    private static class SingletonInstance {
        private static final ImUiKitContactProxyImpl mInstance = new ImUiKitContactProxyImpl();

        private SingletonInstance() {
        }
    }
}

