/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.core.repository.impl.datasource;

import android.content.Context;
import android.text.TextUtils;
import com.xdja.im.base.di.scope.Scoped;
import com.xdja.im.common.cache.interf.ConfigCache;
import com.xdja.im.common.cache.interf.UserCache;
import com.xdja.im.common.network.ApiFactoryMe;
import com.xdja.im.common.network.body.ReportBody;
import com.xdja.im.core.repository.interf.datasource.CloudDataStore;
import com.xdja.im.uikit.utils.log.LogUtil;
import javax.inject.Inject;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

public class CloudDataStoreImpl
implements CloudDataStore {
    private Context context;
    private ApiFactoryMe apiFactory;
    private UserCache userCache;
    private ConfigCache configCache;

    @Inject
    public CloudDataStoreImpl(@Scoped(value="application") Context context, ApiFactoryMe apiFactory, UserCache userCache, ConfigCache configCache) {
        this.context = context;
        this.apiFactory = apiFactory;
        this.userCache = userCache;
        this.configCache = configCache;
    }

    @Override
    public void reportPushClientId(String appId, Subscriber<Boolean> subscriber) {
        String account = this.userCache.get().getAccount();
        String clientId = this.userCache.get().getClientId();
        int type = this.configCache.getDevice().getDeviceType();
        if (TextUtils.isEmpty((CharSequence)account) || TextUtils.isEmpty((CharSequence)clientId)) {
            LogUtil.e("Report push clientId error.");
            return;
        }
        ReportBody body = new ReportBody(account, type, clientId, appId);
        LogUtil.d("ReportBody:" + body.toString());
        this.apiFactory.getUserSettingApi().loginReport(body).subscribeOn(Schedulers.newThread()).map((Func1)new Func1<Object, Boolean>(){

            public Boolean call(Object response) {
                return true;
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribe(subscriber);
    }
}

