/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.core.repository.impl.im;

import android.text.TextUtils;
import android.util.Log;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.model.message.mapper.DataMapper;
import com.xdja.im.core.repository.interf.SecurityRepository;
import com.xdja.im.core.repository.interf.im.IMProxyCallBack;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.imsdk.callback.CallbackFunction;
import com.xdja.imsdk.callback.IMFileInfoCallback;
import com.xdja.imsdk.callback.IMMessageCallback;
import com.xdja.imsdk.callback.IMSecurityCallback;
import com.xdja.imsdk.callback.IMSessionCallback;
import com.xdja.imsdk.constant.ChangeAction;
import com.xdja.imsdk.model.IMFileInfo;
import com.xdja.imsdk.model.IMMessage;
import com.xdja.imsdk.model.IMSession;
import com.xdja.imsdk.security.SecurityPara;
import com.xdja.imsdk.security.SecurityResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;

public class IMSDKCallBack
implements CallbackFunction,
IMFileInfoCallback,
IMSessionCallback,
IMMessageCallback,
IMSecurityCallback {
    private DataMapper mapper;
    private IMProxyCallBack callBack;
    private SecurityRepository repository;

    @Inject
    public IMSDKCallBack(DataMapper mapper, IMProxyCallBack callBack, SecurityRepository repository) {
        this.mapper = mapper;
        this.callBack = callBack;
        this.repository = repository;
    }

    public int NewIMMessageCome(IMSession session, List<IMMessage> messageList) {
        if (messageList == null || messageList.size() < 0 || session == null) {
            return 0;
        }
        TalkSessionBean sessionBean = this.mapper.mapTalkSessionBean(session);
        Log.d((String)"NewMsgCome", (String)("sessionBean:" + sessionBean));
        ArrayList<TalkMessageBean> talkMessageBeanList = new ArrayList<TalkMessageBean>();
        for (IMMessage message : messageList) {
            TalkMessageBean talkMessageBean = this.mapper.mapTalkMessageBean(message);
            talkMessageBeanList.add(talkMessageBean);
        }
        return this.callBack.onRemainNewMessage(sessionBean, talkMessageBeanList);
    }

    public int IMSessionListChange(IMSession imSession, ChangeAction action) {
        TalkSessionBean talkSessionBean = this.mapper.mapTalkSessionBean(imSession);
        if (talkSessionBean == null) {
            return 0;
        }
        switch (action) {
            case ACT_ADD: {
                return this.callBack.onCreateNewSession(talkSessionBean);
            }
            case ACT_DEL: {
                return this.callBack.onDeleteSession(talkSessionBean);
            }
            case ACT_RF: 
            case ACT_SC: {
                return this.callBack.onRefreshSession(talkSessionBean);
            }
        }
        return 0;
    }

    public int IMMessageListChange(IMSession session, List<IMMessage> messageList, ChangeAction action) {
        ArrayList<TalkMessageBean> msgBeanList = new ArrayList<TalkMessageBean>();
        for (int i = 0; i < messageList.size(); ++i) {
            TalkMessageBean talkMessageBean = this.mapper.mapTalkMessageBean(messageList.get(i));
            msgBeanList.add(talkMessageBean);
        }
        TalkMessageBean talkMessageBean = (TalkMessageBean)msgBeanList.get(0);
        TalkSessionBean talkSessionBean = this.mapper.mapTalkSessionBean(session);
        switch (action) {
            case ACT_ADD: {
                return this.callBack.onReceiveNewMessage(talkSessionBean.getTalkerAccount(), msgBeanList);
            }
            case ACT_DEL: {
                return this.callBack.onDeleteMessage(talkSessionBean.getTalkerAccount(), talkMessageBean);
            }
            case ACT_RF: {
                return this.callBack.refreshMessageList();
            }
            case ACT_SC: {
                if (!talkMessageBean.isMine() && talkMessageBean.isBomb() && talkMessageBean.getMessageState() == 5) {
                    talkMessageBean.setMessageState(6);
                }
                return this.callBack.onRefreshMessage(talkSessionBean.getTalkerAccount(), talkMessageBean);
            }
        }
        return 0;
    }

    public int IMMessageRecall(IMSession session, IMMessage message, int recallCode) {
        return 0;
    }

    public int ImSdkStateChange(int code) {
        LogUtil.d("ImSdkStateChange:" + code);
        if (code == 50010) {
            return this.callBack.onInitFinished();
        }
        if (code == 50020 || code == 50024) {
            // empty if block
        }
        return 0;
    }

    public int ImSdkNetworkChange(int i) {
        return 0;
    }

    public int CheckVersion(String account) {
        return 0;
    }

    public String GetNoticeByAccount(String s, String s1) {
        return null;
    }

    public String GetSendMessageParamExt() {
        return "{\"checkFri\":0}";
    }

    public void CacheSize(boolean b, long l) {
    }

    public void ImSdkLog(int priority, String tag, String msg, Throwable throwable) {
        switch (priority) {
            case 4: {
                Log.i((String)tag, (String)msg);
                break;
            }
            case 3: {
                Log.d((String)tag, (String)msg);
                break;
            }
            case 6: {
                Log.e((String)tag, (String)msg);
                break;
            }
            case 2: {
                Log.v((String)tag, (String)msg);
                break;
            }
            case 5: {
                Log.w((String)tag, (String)msg);
            }
        }
    }

    public int SendFileProgressUpdate(IMFileInfo imFileInfo) {
        FileInfo fileInfo = this.mapper.mapFileInfo(imFileInfo);
        if (fileInfo == null) {
            return 0;
        }
        IMMessage message = imFileInfo.getMessage();
        return this.callBack.onSendFileProgressUpdate(imFileInfo.getTag(), message.getIMMessageId(), fileInfo, imFileInfo.getPercent());
    }

    public int SendFileFail(IMFileInfo imFileInfo) {
        FileInfo fileInfo = this.mapper.mapFileInfo(imFileInfo);
        if (fileInfo == null) {
            return 0;
        }
        IMMessage message = imFileInfo.getMessage();
        return this.callBack.onSendFileFailed(imFileInfo.getTag(), message.getIMMessageId(), fileInfo, 0);
    }

    public int SendFileFinish(IMFileInfo imFileInfo) {
        FileInfo fileInfo = this.mapper.mapFileInfo(imFileInfo);
        if (fileInfo == null) {
            return 0;
        }
        IMMessage message = imFileInfo.getMessage();
        return this.callBack.onSendFileFinished(imFileInfo.getTag(), message.getIMMessageId(), fileInfo);
    }

    public int ReceiveFileProgressUpdate(IMFileInfo imFileInfo) {
        FileInfo fileInfo = this.mapper.mapFileInfo(imFileInfo);
        if (fileInfo == null) {
            return 0;
        }
        IMMessage message = imFileInfo.getMessage();
        return this.callBack.onReceiveFileProgressUpdate(imFileInfo.getTag(), message.getIMMessageId(), fileInfo, imFileInfo.getPercent());
    }

    public int ReceiveFileFail(IMFileInfo imFileInfo) {
        FileInfo fileInfo = this.mapper.mapFileInfo(imFileInfo);
        if (fileInfo == null) {
            return 0;
        }
        IMMessage message = imFileInfo.getMessage();
        return this.callBack.onReceiveFileFailed(imFileInfo.getTag(), message.getIMMessageId(), fileInfo, 0);
    }

    public int ReceiveFileFinish(IMFileInfo imFileInfo) {
        FileInfo fileInfo = this.mapper.mapFileInfo(imFileInfo);
        if (fileInfo == null) {
            return 0;
        }
        IMMessage message = imFileInfo.getMessage();
        return this.callBack.onReceiveFileFinished(imFileInfo.getTag(), message.getIMMessageId(), fileInfo);
    }

    public int ReceiveFilePaused(IMFileInfo imFileInfo) {
        FileInfo fileInfo = this.mapper.mapFileInfo(imFileInfo);
        if (fileInfo == null) {
            return 0;
        }
        IMMessage message = imFileInfo.getMessage();
        return this.callBack.onReceiveFilePaused(imFileInfo.getTag(), message.getIMMessageId(), fileInfo);
    }

    public SecurityResult EncryptText(String source, SecurityPara para) {
        SecurityResult result = new SecurityResult(2);
        if (TextUtils.isEmpty((CharSequence)source)) {
            result.setResult(source);
            return result;
        }
        String to = para.getPerson();
        boolean isGroup = para.isGroup();
        Map<String, Object> text = this.repository.encryptText(source, to, isGroup);
        return this.getSecurityResult(text);
    }

    public SecurityResult EncryptFile(String source, String dest, SecurityPara para) {
        SecurityResult result = new SecurityResult(2);
        if (TextUtils.isEmpty((CharSequence)source)) {
            result.setResult(source);
            return result;
        }
        String to = para.getPerson();
        boolean isGroup = para.isGroup();
        Map<String, Object> file = this.repository.encryptAsync(source, dest, to, isGroup);
        return this.getSecurityResult(file);
    }

    public SecurityResult DecryptText(String source, SecurityPara para) {
        return null;
    }

    public SecurityResult DecryptFile(String source, String dest, SecurityPara para) {
        return null;
    }

    private SecurityResult getSecurityResult(Map<String, Object> security) {
        SecurityResult securityResult = new SecurityResult(2);
        int code = (Integer)security.get("security_code");
        String result = (String)security.get("security_result");
        if (code != 0) {
            return this.getFailResult(code, result);
        }
        securityResult.setResult(result);
        securityResult.setCode(0);
        return securityResult;
    }

    private SecurityResult getFailResult(int code, String source) {
        SecurityResult result = new SecurityResult(2);
        if (code == 1) {
            result.setCode(1);
        }
        if (code == 2) {
            result.setCode(2);
        }
        result.setResult(source);
        return result;
    }
}

