/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.action.recycler;

import android.graphics.Rect;
import android.support.v7.widget.RecyclerView;
import android.util.SparseArray;
import android.view.View;
import com.xdja.im.lib.action.recycler.PageDecorationLastJudge;

public class HorizontalPageLayoutManager
extends RecyclerView.LayoutManager
implements PageDecorationLastJudge {
    private int totalWidth = 0;
    private int offsetY = 0;
    private int offsetX = 0;
    private SparseArray<Rect> allItemFrames = new SparseArray();
    int rows = 0;
    int columns = 0;
    int pageSize = 0;
    int itemWidth = 0;
    int itemHeight = 0;
    int onePageSize = 0;
    int itemWidthUsed;
    int itemHeightUsed;

    public RecyclerView.LayoutParams generateDefaultLayoutParams() {
        return null;
    }

    public HorizontalPageLayoutManager(int rows, int columns) {
        this.rows = rows;
        this.columns = columns;
        this.onePageSize = rows * columns;
    }

    public boolean canScrollHorizontally() {
        return true;
    }

    public int scrollHorizontallyBy(int dx, RecyclerView.Recycler recycler, RecyclerView.State state) {
        this.detachAndScrapAttachedViews(recycler);
        int newX = this.offsetX + dx;
        int result = dx;
        if (newX > this.totalWidth) {
            result = this.totalWidth - this.offsetX;
        } else if (newX < 0) {
            result = 0 - this.offsetX;
        }
        this.offsetX += result;
        this.offsetChildrenHorizontal(-result);
        this.recycleAndFillItems(recycler, state);
        return result;
    }

    private int getUsableWidth() {
        return this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
    }

    private int getUsableHeight() {
        return this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
    }

    public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.getItemCount() == 0) {
            this.removeAndRecycleAllViews(recycler);
            return;
        }
        if (state.isPreLayout()) {
            return;
        }
        this.itemWidth = this.getUsableWidth() / this.columns;
        this.itemHeight = this.getUsableHeight() / this.rows;
        this.itemWidthUsed = (this.columns - 1) * this.itemWidth;
        this.itemHeightUsed = (this.rows - 1) * this.itemHeight;
        this.pageSize = this.getItemCount() / this.onePageSize + (this.getItemCount() % this.onePageSize == 0 ? 0 : 1);
        this.totalWidth = (this.pageSize - 1) * this.getWidth();
        this.detachAndScrapAttachedViews(recycler);
        int count = this.getItemCount();
        for (int p = 0; p < this.pageSize; ++p) {
            block1: for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    int index = p * this.onePageSize + r * this.columns + c;
                    if (index == count) {
                        c = this.columns;
                        r = this.rows;
                        p = this.pageSize;
                        continue block1;
                    }
                    View view = recycler.getViewForPosition(index);
                    this.addView(view);
                    this.measureChildWithMargins(view, this.itemWidthUsed, this.itemHeightUsed);
                    int width = this.getDecoratedMeasuredWidth(view);
                    int height = this.getDecoratedMeasuredHeight(view);
                    Rect rect = (Rect)this.allItemFrames.get(index);
                    if (rect == null) {
                        rect = new Rect();
                    }
                    int x = p * this.getUsableWidth() + c * this.itemWidth;
                    int y = r * this.itemHeight;
                    rect.set(x, y, width + x, height + y);
                    this.allItemFrames.put(index, (Object)rect);
                }
            }
            this.removeAndRecycleAllViews(recycler);
        }
        this.recycleAndFillItems(recycler, state);
    }

    public void onDetachedFromWindow(RecyclerView view, RecyclerView.Recycler recycler) {
        super.onDetachedFromWindow(view, recycler);
        this.offsetX = 0;
        this.offsetY = 0;
    }

    private void recycleAndFillItems(RecyclerView.Recycler recycler, RecyclerView.State state) {
        int i;
        if (state.isPreLayout()) {
            return;
        }
        Rect displayRect = new Rect(this.getPaddingLeft() + this.offsetX, this.getPaddingTop(), this.getWidth() - this.getPaddingLeft() - this.getPaddingRight() + this.offsetX, this.getHeight() - this.getPaddingTop() - this.getPaddingBottom());
        Rect childRect = new Rect();
        for (i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            childRect.left = this.getDecoratedLeft(child);
            childRect.top = this.getDecoratedTop(child);
            childRect.right = this.getDecoratedRight(child);
            childRect.bottom = this.getDecoratedBottom(child);
            if (Rect.intersects((Rect)displayRect, (Rect)childRect)) continue;
            this.removeAndRecycleView(child, recycler);
        }
        for (i = 0; i < this.getItemCount(); ++i) {
            if (!Rect.intersects((Rect)displayRect, (Rect)((Rect)this.allItemFrames.get(i)))) continue;
            View view = recycler.getViewForPosition(i);
            this.addView(view);
            this.measureChildWithMargins(view, this.itemWidthUsed, this.itemHeightUsed);
            Rect rect = (Rect)this.allItemFrames.get(i);
            this.layoutDecorated(view, rect.left - this.offsetX, rect.top, rect.right - this.offsetX, rect.bottom);
        }
    }

    @Override
    public boolean isLastRow(int index) {
        if (index >= 0 && index < this.getItemCount()) {
            int indexOfPage = index % this.onePageSize;
            if (++indexOfPage > (this.rows - 1) * this.columns && indexOfPage <= this.onePageSize) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isLastColumn(int position) {
        return position >= 0 && position < this.getItemCount() && ++position % this.columns == 0;
    }

    @Override
    public boolean isPageLast(int position) {
        return ++position % this.onePageSize == 0;
    }
}

