/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.album.ui.adapter;

import android.app.Activity;
import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import com.xdja.im.lib.album.ImagePickerConfig;
import com.xdja.im.lib.album.ImagePickerManager;
import com.xdja.im.lib.album.bean.ImageItem;
import com.xdja.im.lib.album.listener.OnItemClickListener;
import com.xdja.im.lib.album.listener.OnItemDataChangedListener;
import com.xdja.im.lib.album.ui.viewholder.BaseViewHolder;
import com.xdja.im.lib.album.ui.viewholder.CameraViewHolder;
import com.xdja.im.lib.album.ui.viewholder.ImageViewHolder;
import com.xdja.im.lib.album.ui.viewholder.VideoViewHolder;
import com.xdja.im.uikit.R;
import java.util.List;

public abstract class ImagePickerAdapter
extends RecyclerView.Adapter<BaseViewHolder> {
    public static final int ITEM_TYPE_IMAGE = 0;
    public static final int ITEM_TYPE_VIDEO = 1;
    public static final int ITEM_TYPE_CAMERA = 2;
    private Activity mActivity;
    private ImagePickerConfig mConfig;
    private List<ImageItem> mImageItemList;
    private int mItemType = 0;

    public ImagePickerAdapter(Activity activity, List<ImageItem> datas) {
        this.mActivity = activity;
        this.mImageItemList = datas;
        this.mConfig = ImagePickerManager.getInstance().getConfig();
    }

    public ImageItem getItemData(int position) {
        if (this.mConfig.getType() == 0) {
            return this.mImageItemList.get(position);
        }
        if (position == 0) {
            return null;
        }
        return this.mImageItemList.get(position - 1);
    }

    public int getItemViewType(int position) {
        ImageItem item = this.getItemData(position);
        if (item == null) {
            this.mItemType = 2;
            return 2;
        }
        if (item.getType() == 0) {
            this.mItemType = 0;
            return 0;
        }
        this.mItemType = 1;
        return 1;
    }

    public BaseViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        BaseViewHolder viewHolder = this.mItemType == 1 ? new VideoViewHolder(this.mActivity, inflater.inflate(R.layout.im_uikit_item_action_album_video, parent, false)) : (this.mItemType == 2 ? new CameraViewHolder(this.mActivity, inflater.inflate(R.layout.im_uikit_item_action_album_camera, parent, false)) : new ImageViewHolder(this.mActivity, inflater.inflate(R.layout.im_uikit_item_action_album_image, parent, false)));
        viewHolder.setOnItemClickListener(this.getOnItemClickListener());
        viewHolder.setOnItemDataChangedListener(this.getOnItemDataChangedListener());
        return viewHolder;
    }

    public void onBindViewHolder(BaseViewHolder holder, int position) {
        if (holder != null) {
            holder.bindData(this.getItemData(position));
        }
    }

    public int getItemCount() {
        return this.mImageItemList == null ? 0 : this.mImageItemList.size();
    }

    public abstract OnItemClickListener getOnItemClickListener();

    public abstract OnItemDataChangedListener getOnItemDataChangedListener();
}

