/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.album.ui.view;

import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ProgressBar;
import com.xdja.im.common.utils.FileSizeUtils;
import com.xdja.im.lib.album.ImageDataSource;
import com.xdja.im.lib.album.bean.ImageItem;
import com.xdja.im.lib.album.ui.adapter.ImagePreviewAdapter;
import com.xdja.im.lib.album.ui.presenter.ImagePreviewPresenter;
import com.xdja.im.lib.album.ui.view.vu.ImagePreviewVu;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.base.ImActivitySuperView;
import com.xdja.im.uikit.utils.log.LogUtil;

public class ViewImagePreview
extends ImActivitySuperView<ImagePreviewPresenter>
implements ImagePreviewVu,
ViewPager.OnPageChangeListener,
View.OnClickListener {
    private ViewPager mViewPager;
    private Button mSendBtn;
    private Button mOriginBtn;
    private Button mSelectBtn;
    private ProgressBar mLoadingPBar;
    private int mCurrentItemIndex;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_activity_image_preview;
    }

    @Override
    protected int getToolbarType() {
        return 0;
    }

    @Override
    protected void injectView() {
        super.injectView();
        this.mViewPager = (ViewPager)this.findViewById(R.id.viewpager);
        this.mSendBtn = (Button)this.findViewById(R.id.btn_send);
        this.mOriginBtn = (Button)this.findViewById(R.id.btn_original);
        this.mSelectBtn = (Button)this.findViewById(R.id.btn_select);
        this.mLoadingPBar = (ProgressBar)this.findViewById(R.id.pbar_loading);
        this.mSendBtn.setOnClickListener((View.OnClickListener)this);
        this.mSelectBtn.setOnClickListener((View.OnClickListener)this);
        this.mViewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.mOriginBtn.setOnClickListener((View.OnClickListener)this);
    }

    @Override
    public void setAdapter(ImagePreviewAdapter adapter) {
        this.mViewPager.setAdapter((PagerAdapter)adapter);
        adapter.notifyDataSetChanged();
        this.refreshTitleIndicator();
        this.refreshSelectPictureIndicator();
        this.refreshLocalPictureInfo(0);
    }

    @Override
    public void setCurrentPosition(int position) {
        this.mViewPager.setCurrentItem(position);
    }

    @Override
    public void refreshTitleIndicator() {
        this.getActivity().setTitle((CharSequence)String.format(this.getStringRes(R.string.im_uikit_selest), this.mCurrentItemIndex + 1, ((ImagePreviewPresenter)this.getPresenter()).getImageSize()));
    }

    @Override
    public int getSelectedCount() {
        return ImageDataSource.getInstance().size();
    }

    @Override
    public void setProgressBarVisible(boolean bVisible) {
        this.mLoadingPBar.setVisibility(bVisible ? 0 : 8);
    }

    @Override
    public void refreshSelectPictureIndicator() {
        int selectCnt = this.getSelectedCount();
        if (selectCnt > 0) {
            this.setSendBtnClickable(true);
            this.mSendBtn.setText((CharSequence)String.format(this.getStringRes(R.string.im_uikit_picture_send_indicator), selectCnt, 9));
        } else {
            this.setSendBtnClickable(false);
            this.mSendBtn.setText(R.string.im_uikit_send);
        }
    }

    private void setSendBtnClickable(boolean clickable) {
        if (clickable) {
            this.mSendBtn.setClickable(true);
            ViewGroup.LayoutParams params = this.mSendBtn.getLayoutParams();
            params.width = -2;
            this.mSendBtn.setLayoutParams(params);
            this.mSendBtn.setTextColor(Color.parseColor((String)"#F3000000"));
        } else {
            this.mSendBtn.setClickable(false);
            ViewGroup.LayoutParams params = this.mSendBtn.getLayoutParams();
            params.width = (int)TypedValue.applyDimension((int)1, (float)46.0f, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
            this.mSendBtn.setLayoutParams(params);
            this.mSendBtn.setTextColor(Color.parseColor((String)"#77000000"));
        }
    }

    @Override
    public void refreshLocalPictureInfo(int position) {
        ImageItem imageItem = ((ImagePreviewPresenter)this.getPresenter()).getImageItem(position);
        if (imageItem == null) {
            LogUtil.e("ERROR: get image info error. " + position);
            return;
        }
        this.mOriginBtn.setText((CharSequence)String.format(this.getStringRes(R.string.im_uikit_original_image), FileSizeUtils.formatFileSize(imageItem.getSize())));
        boolean isSelect = ImageDataSource.getInstance().contains(imageItem);
        this.mSelectBtn.setBackgroundResource(isSelect ? R.mipmap.im_uikit_icon_selected_on : R.mipmap.im_uikit_icon_selected_off);
        if (imageItem.isOriginal()) {
            this.mOriginBtn.setTextColor(Color.parseColor((String)"#F3000000"));
            this.setOriginalPictureResource(R.mipmap.im_uikit_icon_selected_on);
        } else {
            this.mOriginBtn.setTextColor(Color.parseColor((String)"#77000000"));
            this.setOriginalPictureResource(R.mipmap.im_uikit_icon_selected_off);
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
    }

    public void onPageSelected(int position) {
        this.mCurrentItemIndex = position;
        this.refreshTitleIndicator();
        this.refreshLocalPictureInfo(position);
    }

    public void onPageScrollStateChanged(int state) {
    }

    public void onClick(View v) {
        int resId = v.getId();
        if (resId == R.id.btn_send) {
            this.mSendBtn.setEnabled(false);
            this.mOriginBtn.setEnabled(false);
            ((ImagePreviewPresenter)this.getPresenter()).sendImages(ImageDataSource.getInstance().getSelects());
        } else if (resId == R.id.btn_select) {
            ImageItem imageItem = ((ImagePreviewPresenter)this.getPresenter()).getImageItem(this.mCurrentItemIndex);
            boolean isSelect = ImageDataSource.getInstance().contains(imageItem);
            if (!isSelect && ImageDataSource.getInstance().size() >= 9) {
                this.showToast(String.format(this.getStringRes(R.string.im_uikit_img_select_limit), 9));
                return;
            }
            if (isSelect) {
                ImageDataSource.getInstance().remove(imageItem);
                this.setSelectPicture(false);
                this.setOriginalPictureResource(R.mipmap.im_uikit_icon_selected_off);
            } else {
                ImageDataSource.getInstance().add(imageItem);
                this.setSelectPicture(true);
            }
            this.refreshSelectPictureIndicator();
        } else if (resId == R.id.btn_original) {
            ImageItem imageItem = ((ImagePreviewPresenter)this.getPresenter()).getImageItem(this.mCurrentItemIndex);
            boolean isOriginal = imageItem.isOriginal();
            if (isOriginal) {
                this.mOriginBtn.setTextColor(Color.parseColor((String)"#77000000"));
                this.setOriginalPictureResource(R.mipmap.im_uikit_icon_selected_off);
            } else {
                boolean isSelect = ImageDataSource.getInstance().contains(imageItem);
                if (!isSelect && ImageDataSource.getInstance().size() >= 9) {
                    this.showToast(String.format(this.getStringRes(R.string.im_uikit_img_select_limit), 9));
                    return;
                }
                this.mOriginBtn.setTextColor(Color.parseColor((String)"#F3000000"));
                this.mOriginBtn.setText((CharSequence)String.format(this.getStringRes(R.string.im_uikit_original_image), FileSizeUtils.formatFileSize(imageItem.getSize())));
                this.mSelectBtn.setBackgroundResource(R.mipmap.im_uikit_icon_selected_on);
                this.setOriginalPictureResource(R.mipmap.im_uikit_icon_selected_on);
            }
            imageItem.setOriginalState(!isOriginal);
            ImageDataSource.getInstance().updateItem(imageItem);
            ((ImagePreviewPresenter)this.getPresenter()).updateItem(this.mCurrentItemIndex, imageItem);
            this.refreshSelectPictureIndicator();
        }
    }

    private void setSelectPicture(boolean isSelect) {
        if (isSelect) {
            this.mSelectBtn.setBackgroundResource(R.mipmap.im_uikit_icon_selected_on);
        } else {
            this.mSelectBtn.setBackgroundResource(R.mipmap.im_uikit_icon_selected_off);
        }
    }

    private void setOriginalPictureResource(int resId) {
        Drawable unSelectDrawable = this.getDrawableRes(resId);
        if (unSelectDrawable != null) {
            unSelectDrawable.setBounds(0, 0, unSelectDrawable.getIntrinsicWidth(), unSelectDrawable.getIntrinsicHeight());
            this.mOriginBtn.setCompoundDrawables(unSelectDrawable, null, null, null);
        }
    }
}

