/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.camera.ui.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.hardware.Camera;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.common.utils.PermissionUtils;
import com.xdja.im.lib.camera.CameraManager;
import com.xdja.im.lib.camera.bean.PhotoItem;
import com.xdja.im.lib.camera.bean.PhotoThumbBean;
import com.xdja.im.lib.camera.ui.presenter.TakePhotoPresenter;
import com.xdja.im.lib.camera.ui.view.ViewTakePhoto;
import com.xdja.im.lib.camera.ui.view.vu.TakePhotoVu;
import com.xdja.im.lib.camera.utils.CameraHelper;
import com.xdja.im.lib.camera.utils.DataTools;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.base.ImBaseActivity;
import com.xdja.im.uikit.utils.log.LogUtil;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

public class TakePhotoActivity
extends ImBaseActivity<TakePhotoPresenter, TakePhotoVu>
implements TakePhotoPresenter {
    @Override
    @NonNull
    protected Class<? extends TakePhotoVu> getVuClass() {
        return ViewTakePhoto.class;
    }

    @Override
    @NonNull
    protected TakePhotoPresenter getPresenter() {
        return this;
    }

    @Override
    protected void onBindView(@Nullable Bundle savedInstanceState) {
        super.onBindView(savedInstanceState);
        if (Build.VERSION.SDK_INT <= 23) {
            this.openCamera();
        } else {
            this.requestPermission();
        }
    }

    private void openCamera() {
        Camera camera = null;
        try {
            camera = Camera.open((int)0);
            CameraHelper.takePhoto((Activity)this, 3);
        }
        catch (Exception e) {
            LogUtil.e("ERROR: Open camera error.");
            CommonTool.showToast(R.string.im_uikit_camera_deny);
            this.finish();
        }
        finally {
            if (camera != null) {
                camera.release();
                camera = null;
            }
        }
    }

    private void requestPermission() {
        if (PermissionUtils.hasSelfPermissions((Context)this, "android.permission.CAMERA", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE")) {
            CameraHelper.takePhoto((Activity)this, 3);
        } else {
            PermissionUtils.requestPermissions((Activity)this, new String[]{"android.permission.CAMERA", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"}, 2);
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 2) {
            if (grantResults.length > 0 && grantResults[0] == 0) {
                CameraHelper.takePhoto((Activity)this, 3);
            } else {
                this.showToast(R.string.im_uikit_camera_deny);
                this.finish();
            }
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1 && requestCode == 3) {
            CameraHelper.galleryAddPic((Activity)this, CameraHelper.getTakePhotoFile());
            ((TakePhotoVu)this.getVu()).loadImage(CameraHelper.getTakePhotoFile());
        } else {
            this.finish();
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (CameraManager.getInstance().getImageLoader() != null) {
            CameraManager.getInstance().getImageLoader().clearMemoryCache((Activity)this);
        }
    }

    @Override
    public void sendPhoto(PhotoItem photoItem, final boolean needOrigin) {
        Observable.just((Object)photoItem).subscribeOn(Schedulers.computation()).flatMap((Func1)new Func1<PhotoItem, Observable<PhotoThumbBean>>(){

            public Observable<PhotoThumbBean> call(PhotoItem photoItem) {
                photoItem.setbOriginal(needOrigin);
                return DataTools.createImageThumb(photoItem);
            }
        }).subscribe((Subscriber)new Subscriber<PhotoThumbBean>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
            }

            public void onNext(PhotoThumbBean photoThumbBean) {
                TakePhotoActivity.this.setResult(photoThumbBean);
            }
        });
    }

    private void setResult(PhotoThumbBean thumbBean) {
        Intent intent = new Intent();
        intent.putExtra("album_photo", (Parcelable)thumbBean);
        this.setResult(3, intent);
        this.finish();
    }
}

