/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.camera.ui.view;

import android.app.Activity;
import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.xdja.im.common.utils.FileSizeUtils;
import com.xdja.im.lib.camera.bean.PhotoItem;
import com.xdja.im.lib.camera.ui.presenter.TakePhotoPresenter;
import com.xdja.im.lib.camera.ui.view.vu.TakePhotoVu;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.base.ImActivitySuperView;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.view.PhotoView;
import java.io.File;

public class ViewTakePhoto
extends ImActivitySuperView<TakePhotoPresenter>
implements TakePhotoVu {
    private PhotoView mPhotoView;
    private CheckBox mOriginChx;
    private Button mSendBtn;
    private boolean bOrigin;
    private PhotoItem photoItem;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_activity_take_photo;
    }

    @Override
    protected int getToolbarType() {
        return 0;
    }

    @Override
    protected void injectView() {
        super.injectView();
        this.mPhotoView = (PhotoView)this.findViewById(R.id.img_preview);
        this.mOriginChx = (CheckBox)this.findViewById(R.id.btn_original_pic_select);
        this.mSendBtn = (Button)this.findViewById(R.id.btn_send);
        this.mOriginChx.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                ViewTakePhoto.this.bOrigin = isChecked;
            }
        });
        this.mSendBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ViewTakePhoto.this.photoItem != null) {
                    ((TakePhotoPresenter)ViewTakePhoto.this.getPresenter()).sendPhoto(ViewTakePhoto.this.photoItem, ViewTakePhoto.this.bOrigin);
                }
            }
        });
        this.mPhotoView.enable();
        this.mPhotoView.setAdjustViewBounds(true);
        this.getView().setVisibility(8);
    }

    @Override
    public void loadImage(File file) {
        this.getView().setVisibility(0);
        if (!file.exists()) {
            LogUtil.e("Take photo, but file is not exist.");
            return;
        }
        this.photoItem = new PhotoItem();
        this.photoItem.setFileName(file.getName());
        this.photoItem.setFilePath(file.getPath());
        this.photoItem.setFileSize(file.length());
        String fileSizeContent = FileSizeUtils.getAutoFileOrFilesSize(file.getPath());
        this.mOriginChx.setText((CharSequence)String.format(this.getStringRes(R.string.im_uikit_original_image), fileSizeContent));
        Glide.with((Activity)this.getActivity()).load(file).error(R.mipmap.im_uikit_pic_default).into((ImageView)this.mPhotoView);
    }
}

