/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.file.widget.recyclerview;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;

public class ViewHolder
extends RecyclerView.ViewHolder {
    private SparseArray<View> views;
    private View convertView;
    private Context context;

    public ViewHolder(Context context, View itemView) {
        super(itemView);
        this.context = context;
        this.convertView = itemView;
        this.views = new SparseArray();
    }

    public static ViewHolder createViewHolder(Context context, ViewGroup parent, int layoutId) {
        View view = LayoutInflater.from((Context)context).inflate(layoutId, parent, false);
        ViewHolder holder = new ViewHolder(context, view);
        return holder;
    }

    public <T extends View> T getView(int viewId) {
        View view = (View)this.views.get(viewId);
        if (view == null) {
            view = this.convertView.findViewById(viewId);
            this.views.put(viewId, (Object)view);
        }
        return (T)view;
    }

    public View getConvertView() {
        return this.convertView;
    }

    public void setText(int tvId, String text) {
        Object tv = this.getView(tvId);
        if (tv instanceof TextView) {
            ((TextView)tv).setText((CharSequence)text);
        }
    }

    public void setText(int tvId, int textId) {
        Object tv = this.getView(tvId);
        if (tv instanceof TextView) {
            ((TextView)tv).setText(textId);
        }
    }

    public void setImageWithResource(int ivId, int resourceId) {
        Object view = this.getView(ivId);
        if (view instanceof ImageView) {
            ((ImageView)view).setImageResource(resourceId);
        }
    }

    public void setImageWithPath(int ivId, String path, int errorId) {
        Object view = this.getView(ivId);
        if (view instanceof ImageView) {
            ImageView img = (ImageView)view;
            Glide.with((Context)this.context).load(path).error(errorId).centerCrop().override(360, 360).into(img);
        }
    }

    public void setChecked(int checkId, boolean isCheck) {
        Object view = this.getView(checkId);
        if (view instanceof CheckBox) {
            ((CheckBox)view).setChecked(isCheck);
        }
    }
}

