/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.video.ui.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.hardware.Camera;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.common.utils.PermissionUtils;
import com.xdja.im.lib.video.bean.VideoItem;
import com.xdja.im.lib.video.ui.presenter.VideoRecorderPresenter;
import com.xdja.im.lib.video.ui.view.ViewVideoRecorder;
import com.xdja.im.lib.video.ui.view.vu.VideoRecorderVu;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.base.ImBaseActivity;
import com.xdja.im.uikit.utils.log.LogUtil;

public class VideoRecorderActivity
extends ImBaseActivity<VideoRecorderPresenter, VideoRecorderVu>
implements VideoRecorderPresenter {
    @Override
    @NonNull
    protected Class<? extends VideoRecorderVu> getVuClass() {
        return ViewVideoRecorder.class;
    }

    @Override
    @NonNull
    protected VideoRecorderPresenter getPresenter() {
        return this;
    }

    @Override
    protected void preBindView(@Nullable Bundle savedInstanceState) {
        super.preBindView(savedInstanceState);
        this.getWindow().getDecorView().setSystemUiVisibility(1536);
        this.getWindow().addFlags(1536);
    }

    @Override
    protected void onBindView(@Nullable Bundle savedInstanceState) {
        super.onBindView(savedInstanceState);
        if (Build.VERSION.SDK_INT < 23) {
            this.openCamera();
        } else {
            this.requestPermission();
        }
    }

    public void onResume() {
        super.onResume();
        if (((VideoRecorderVu)this.getVu()).isCompleteRecord()) {
            ((VideoRecorderVu)this.getVu()).getVideoManager().resume();
        } else {
            ((VideoRecorderVu)this.getVu()).cancelAndRerecord();
        }
    }

    private void openCamera() {
        Camera camera = null;
        try {
            camera = Camera.open((int)0);
            ((VideoRecorderVu)this.getVu()).startPreview();
        }
        catch (Exception e) {
            LogUtil.e("ERROR: Open camera error.");
            CommonTool.showToast(R.string.im_uikit_camera_deny);
            this.finish();
        }
        finally {
            if (camera != null) {
                camera.release();
                camera = null;
            }
        }
    }

    private void requestPermission() {
        if (PermissionUtils.hasSelfPermissions((Context)this, "android.permission.CAMERA", "android.permission.RECORD_AUDIO", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE")) {
            ((VideoRecorderVu)this.getVu()).startPreview();
        } else {
            PermissionUtils.requestPermissions((Activity)this, new String[]{"android.permission.CAMERA", "android.permission.RECORD_AUDIO", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"}, 2);
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 2) {
            if (grantResults.length > 0 && grantResults[0] == 0) {
                if (grantResults[1] != 0) {
                    this.showToast(R.string.im_uikit_audio_deny);
                    this.finish();
                } else if (grantResults.length >= 4 && grantResults[2] != 0 || grantResults[3] != 0) {
                    this.showToast(R.string.im_uikit_storage_deny);
                    this.finish();
                } else {
                    ((VideoRecorderVu)this.getVu()).startPreview();
                }
            } else {
                this.showToast(R.string.im_uikit_camera_deny);
                this.finish();
            }
        }
    }

    @Override
    public void sendVideoMessage(VideoItem videoItem) {
        Intent intent = new Intent();
        Bundle bundle = new Bundle();
        bundle.putParcelable("im_uikit_video_recorder", (Parcelable)videoItem);
        intent.putExtras(bundle);
        this.setResult(5, intent);
        this.finish();
    }

    public void onBackPressed() {
        int code = ((VideoRecorderVu)this.getVu()).onKeyBack();
        if (code == 1) {
            return;
        }
        super.onBackPressed();
    }

    public void onPause() {
        if (((VideoRecorderVu)this.getVu()).isCompleteRecord()) {
            ((VideoRecorderVu)this.getVu()).getVideoManager().release();
        } else {
            ((VideoRecorderVu)this.getVu()).cancelAndRerecord();
        }
        super.onPause();
    }

    @Override
    public void onDestroy() {
        ((VideoRecorderVu)this.getVu()).getVideoManager().stopPlay(false);
        super.onDestroy();
    }
}

