/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.video.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.xdja.im.lib.video.palyer.VideoPlayState;
import com.xdja.im.lib.video.palyer.VideoPlayerHelper;
import com.xdja.im.lib.video.palyer.onStateChangedListener;
import com.xdja.im.uikit.R;
import java.lang.ref.WeakReference;

public class VideoPlayView
extends RelativeLayout {
    private SurfaceView mSurfaceView;
    private LinearLayout mControllerLayout;
    private CheckBox mPlayChx;
    private TextView mPlayTimeTv;
    private TextView mDurationTv;
    private ProgressBar mPlayPBar;
    private VideoPlayerHelper mHelper;
    private IVideoPlayCallback mPlayCallback;
    private ProgressHandle mHandler;
    private long mDuration = 0L;
    private Runnable controllerRunnable = new Runnable(){

        @Override
        public void run() {
            VideoPlayView.this.mControllerLayout.setVisibility(8);
        }
    };
    private Runnable progressRunnable = new Runnable(){

        @Override
        public void run() {
            if (VideoPlayView.this.mDuration == 0L) {
                return;
            }
            long curPos = (long)((float)VideoPlayView.this.mHelper.getCurrentPosition() * 1.0f / 1000.0f);
            if (curPos < 0L) {
                curPos = 0L;
            }
            VideoPlayView.this.mPlayTimeTv.setText((CharSequence)String.format(VideoPlayView.this.getResources().getString(R.string.im_uikit_video_duration), curPos / 60L, curPos % 60L));
            int progress = (int)((float)curPos * 100.0f / (float)VideoPlayView.this.mDuration);
            VideoPlayView.this.mPlayPBar.setProgress(progress);
            VideoPlayView.this.mHandler.postDelayed(VideoPlayView.this.progressRunnable, 500L);
        }
    };

    public VideoPlayView(Context context) {
        super(context);
        this.init();
    }

    public VideoPlayView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public VideoPlayView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public void setVideoPlayCallback(IVideoPlayCallback playCallback) {
        this.mPlayCallback = playCallback;
    }

    private void init() {
        this.initView();
        this.setListener();
        this.mHandler = new ProgressHandle(new WeakReference<Context>(this.getContext()));
    }

    private void initView() {
        View.inflate((Context)this.getContext(), (int)R.layout.im_uikit_layout_video_player, (ViewGroup)this);
        this.mSurfaceView = (SurfaceView)this.findViewById(R.id.view_surface);
        this.mControllerLayout = (LinearLayout)this.findViewById(R.id.layout_controller);
        this.mPlayChx = (CheckBox)this.findViewById(R.id.chx_play_pause);
        this.mPlayTimeTv = (TextView)this.findViewById(R.id.tv_play_time);
        this.mDurationTv = (TextView)this.findViewById(R.id.tv_video_duration);
        this.mPlayPBar = (ProgressBar)this.findViewById(R.id.pbar_progress);
        this.mHelper = new VideoPlayerHelper(this.mSurfaceView.getHolder());
        this.mPlayTimeTv.setText((CharSequence)String.format(this.getResources().getString(R.string.im_uikit_video_duration), 0, 0));
        this.mDurationTv.setText((CharSequence)String.format(this.getResources().getString(R.string.im_uikit_video_duration), this.mDuration / 60L, this.mDuration % 60L));
    }

    private void setListener() {
        this.mHelper.setOnStateChangedListener(new onStateChangedListener(){

            @Override
            public void onStateChanged(VideoPlayState state) {
                if (state == VideoPlayState.COMPLETION) {
                    VideoPlayView.this.removeAllCallbacks();
                    VideoPlayView.this.playCompleted();
                } else if (state == VideoPlayState.ERROR || state == VideoPlayState.EXCEPTION) {
                    VideoPlayView.this.removeAllCallbacks();
                }
            }
        });
        this.mSurfaceView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (VideoPlayView.this.mControllerLayout.getVisibility() == 8) {
                    VideoPlayView.this.mControllerLayout.setVisibility(0);
                    VideoPlayView.this.mHandler.postDelayed(VideoPlayView.this.controllerRunnable, 2000L);
                }
                return false;
            }
        });
        this.mPlayChx.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (isChecked) {
                    VideoPlayView.this.pause();
                } else {
                    VideoPlayView.this.resume();
                }
            }
        });
    }

    private void removeAllCallbacks() {
        this.mHandler.removeCallbacks(this.controllerRunnable);
        this.mHandler.removeCallbacks(this.progressRunnable);
    }

    private void playCompleted() {
        this.mPlayPBar.setProgress(100);
        this.mPlayTimeTv.setText((CharSequence)String.format(this.getResources().getString(R.string.im_uikit_video_duration), this.mDuration / 60L, this.mDuration % 60L));
        this.mPlayChx.setChecked(false);
        if (this.mPlayCallback != null) {
            this.mPlayCallback.completeListener();
        }
    }

    public void setDuration(long duration) {
        this.mDuration = duration;
        this.mDurationTv.setText((CharSequence)String.format(this.getResources().getString(R.string.im_uikit_video_duration), this.mDuration / 60L, this.mDuration % 60L));
    }

    public VideoPlayState getVideoPlayState() {
        return this.mHelper.getPlayState();
    }

    public void play(String filePath) {
        this.mControllerLayout.setVisibility(0);
        this.mPlayPBar.setProgress(0);
        this.mHandler.postDelayed(this.progressRunnable, 500L);
        this.mHelper.play(filePath, false);
    }

    public void pause() {
        this.mHelper.pause();
        this.removeAllCallbacks();
    }

    public void resume() {
        this.mHelper.resume();
        this.mHandler.postDelayed(this.progressRunnable, 500L);
    }

    public void stop() {
        this.mHelper.stop();
        this.removeAllCallbacks();
    }

    public void destroy() {
        this.mHelper.destroy();
        this.removeAllCallbacks();
    }

    public void reset() {
        this.mHelper.reset();
        this.removeAllCallbacks();
    }

    public boolean isPlaying() {
        return this.mHelper.isPlaying();
    }

    public static interface IVideoPlayCallback {
        public void prepareListener();

        public void progressListener(int var1);

        public void completeListener();

        public void pauseListener(int var1);

        public void resumeListener(int var1);

        public void surfacePrepareCallback();

        public void surfaceDestroyListener(Bitmap var1);
    }

    private class ProgressHandle
    extends Handler {
        WeakReference<Context> mReference;

        public ProgressHandle(WeakReference<Context> reference) {
            this.mReference = reference;
        }
    }
}

