/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.view;

import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.google.gson.Gson;
import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.model.custom.CustomMsgInfo;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.proxy.IMUiKitProxyImpl;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.action.options.ImOption;
import com.xdja.im.uikit.ui.dialog.BaseListDialog;
import com.xdja.im.uikit.ui.presenter.ChatListAdapterPresenter;
import com.xdja.im.uikit.ui.view.BaseChatItem;
import java.util.ArrayList;
import rx.Subscriber;

public class ViewCustomRecItem
extends BaseChatItem {
    private ImageView imgCustomType;
    private TextView tvCustominfo;
    private LinearLayout linearLayout;
    private CustomMsgInfo customMsgInfo;
    private ImageView missedMsgIv;
    private TextView senderNameTextView;
    private Gson gson = new Gson();
    private static final String SINGLE_VOICE = "single_voice";
    private static final String SINGLE_CALLBACK = "single_video";
    private static final String GROUP_VOICE = "group_voice";

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_item_chat_receive_custom;
    }

    @Override
    protected void injectView() {
        super.injectView();
        this.senderNameTextView = (TextView)this.findViewById(R.id.txt_chat_senderName);
        this.imgCustomType = (ImageView)this.findViewById(R.id.img_custom_rec);
        this.tvCustominfo = (TextView)this.findViewById(R.id.tv_custom_info);
        this.missedMsgIv = (ImageView)this.findViewById(R.id.img_new_flag);
        this.linearLayout = (LinearLayout)this.findViewById(R.id.layout_message_container);
        this.linearLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CustomMsgInfo customMsgInfo = (CustomMsgInfo)ViewCustomRecItem.this.gson.fromJson(((TalkMessageBean)ViewCustomRecItem.this.dataSource).getContent(), CustomMsgInfo.class);
                int type = customMsgInfo.getType();
                if (customMsgInfo.getState() == 4 || customMsgInfo.getState() == 6) {
                    ((ChatListAdapterPresenter)ViewCustomRecItem.this.getPresenter()).sendReadReceipt((TalkMessageBean)ViewCustomRecItem.this.dataSource);
                }
                switch (type) {
                    case 3: {
                        IMUiKitProxyImpl.getInstance().startCallback(customMsgInfo.getFromAtNo());
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 1: {
                        IMUiKitProxyImpl.getInstance().startVoice(customMsgInfo.getFromAtNo(), 1);
                        if (ViewCustomRecItem.this.missedMsgIv == null) break;
                        ViewCustomRecItem.this.missedMsgIv.setVisibility(8);
                        break;
                    }
                    case 2: {
                        IMUiKitProxyImpl.getInstance().startVoice(customMsgInfo.getToAtNo(), 2);
                        if (ViewCustomRecItem.this.missedMsgIv == null) break;
                        ViewCustomRecItem.this.missedMsgIv.setVisibility(8);
                    }
                }
            }
        });
        this.linearLayout.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                ArrayList<ImOption> data = new ArrayList<ImOption>();
                data.add((ImOption)ViewCustomRecItem.this.mImOptions.get(0));
                ViewCustomRecItem.this.mPopDialog.addData(data);
                ViewCustomRecItem.this.mPopDialog.show(ViewCustomRecItem.this.curPosition);
                return true;
            }
        });
        this.mPopDialog.setOnItemClickListener(new BaseListDialog.onItemClickListener(){

            @Override
            public void onItemClick(View view, ImOption option, int itemPosition) {
                ViewCustomRecItem.this.mPopDialog.dismiss();
                switch (option.getOptionType()) {
                    case 1: {
                        ((ChatListAdapterPresenter)ViewCustomRecItem.this.getPresenter()).deleteItem(itemPosition);
                    }
                }
            }
        });
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkMessageBean dataSource) {
        super.bindDataSource(position, dataSource);
        if (dataSource.getMessageType() == 2) {
            ((ChatListAdapterPresenter)this.getPresenter()).getAccount(dataSource.getFrom(), 1, new Subscriber<AccountBean>(){

                public void onCompleted() {
                }

                public void onError(Throwable e) {
                }

                public void onNext(AccountBean accountBean) {
                    ViewCustomRecItem.this.senderNameTextView.setText((CharSequence)accountBean.getDisplayName());
                }
            });
        } else {
            this.senderNameTextView.setVisibility(8);
        }
        this.customMsgInfo = (CustomMsgInfo)this.gson.fromJson(dataSource.getContent(), CustomMsgInfo.class);
        int type = this.customMsgInfo.getType();
        int state = this.customMsgInfo.getState();
        boolean isRecalled = dataSource.getMessageState() == 4;
        long amountOfTime = this.customMsgInfo.getAmountOfTime();
        boolean isVideoCallback = type == 3 || type == 4;
        String content = "";
        if (state == 4) {
            content = isVideoCallback ? "\u672a\u63a5\u89c6\u9891\u56de\u4f20" : "\u672a\u63a5\u8bed\u97f3\u901a\u8bdd";
        } else if (state == 6) {
            content = isVideoCallback ? "\u672a\u63a5\u89c6\u9891\u56de\u4f20" : (type == 1 ? "\u672a\u63a5\u8bed\u97f3\u901a\u8bdd" : "\u672a\u63a5\u8bed\u97f3\u4f1a\u8bae");
        } else if (state == 5) {
            content = "\u5df2\u62d2\u7edd";
        } else if (state == 2) {
            content = this.buildMsgContent(type, amountOfTime);
        }
        if (isVideoCallback) {
            this.imgCustomType.setBackgroundResource(R.mipmap.im_uikit_icon_custom_callback);
        } else {
            this.imgCustomType.setBackgroundResource(R.mipmap.im_uikit_icon_custom_meeting);
        }
        this.tvCustominfo.setText((CharSequence)content);
        if (!(isRecalled || state != 4 && state != 6)) {
            this.missedMsgIv.setVisibility(0);
        } else {
            this.missedMsgIv.setVisibility(8);
        }
    }

    private String buildMsgContent(int type, long amountOfTime) {
        StringBuilder builder = new StringBuilder();
        switch (type) {
            case 3: 
            case 4: {
                builder.append("\u89c6\u9891\u56de\u4f20");
                builder.append(" " + this.getFormatTime(amountOfTime));
                break;
            }
            case 1: {
                builder.append("\u8bed\u97f3\u901a\u8bdd");
                builder.append(" " + this.getFormatTime(amountOfTime));
                break;
            }
            case 2: {
                builder.append("\u8bed\u97f3\u4f1a\u8bae");
            }
        }
        return builder.toString();
    }

    private String getFormatTime(long amountOfTime) {
        long hour = amountOfTime / 3600L;
        long min = amountOfTime / 60L % 60L;
        long second = amountOfTime % 60L;
        String hourStr = hour < 10L ? "0" + hour : "" + hour;
        String minStr = min < 10L ? "0" + min : "" + min;
        String secondStr = second < 10L ? "0" + second : "" + second;
        return hourStr + ":" + minStr + ":" + secondStr;
    }
}

