/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.view;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;
import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.core.model.param.SessionParam;
import com.xdja.im.lib.emoji.utils.EmotionUtils;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.ui.presenter.SessionListAdapterPresenter;
import com.xdja.im.uikit.ui.view.ViewSessionItem;
import com.xdja.im.uikit.utils.log.LogUtil;

public class ViewGroupItem
extends ViewSessionItem {
    public static final String SEPARATOR = ": ";
    private TextView senderName;
    private TextView senderNameSeparator;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_item_session_group;
    }

    @Override
    protected void injectView() {
        super.injectView();
        View view = this.getView();
        if (null != view) {
            this.senderName = (TextView)view.findViewById(R.id.tv_senderName);
            this.senderNameSeparator = (TextView)view.findViewById(R.id.tv_senderNameSeparate);
        }
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkSessionBean dataSource) {
        super.bindDataSource(position, dataSource);
        this.updateSessionSenderInfo();
    }

    @Override
    public void onViewReused() {
        super.onViewReused();
        this.senderName.setVisibility(8);
        this.senderNameSeparator.setVisibility(8);
    }

    @Override
    protected CharSequence getContent(String displayName) {
        if (((TalkSessionBean)this.dataSource).getLastMsg() != null && ((TalkSessionBean)this.dataSource).getLastMsg().isMine()) {
            this.senderName.setVisibility(8);
            this.senderNameSeparator.setVisibility(8);
            return this.getMessageContent("");
        }
        this.senderName.setVisibility(0);
        this.senderName.setText((CharSequence)displayName);
        this.senderNameSeparator.setVisibility(0);
        return this.getMessageContent(displayName);
    }

    private CharSequence getMessageContent(String displayName) {
        TalkMessageBean talkMessageBean = ((TalkSessionBean)this.dataSource).getLastMsg();
        SessionParam param = ((TalkSessionBean)this.dataSource).getParam();
        if (param != null && !TextUtils.isEmpty((CharSequence)param.getDraftContent()) && param.getDraftTime() > 0L) {
            CharSequence content = this.formatDraft(param.getDraftContent());
            LogUtil.d("ViewGroupItem draft:" + content);
            return EmotionUtils.formatSpanContent(content, (Context)this.getActivity(), 0.8f);
        }
        if (talkMessageBean == null) {
            LogUtil.w("Last message info is null.");
            return "";
        }
        int messageType = talkMessageBean.getMessageType();
        switch (messageType) {
            case 0: {
                return EmotionUtils.formatSpanContent(((TalkSessionBean)this.dataSource).getContent(), (Context)this.getActivity(), 0.8f);
            }
            case 1: {
                return this.getStringRes(R.string.im_uikit_voice);
            }
            case 2: {
                return this.getStringRes(R.string.im_uikit_video);
            }
            case 3: {
                return this.getStringRes(R.string.im_uikit_image);
            }
            case 4: {
                return this.getStringRes(R.string.im_uikit_file);
            }
        }
        return ((TalkSessionBean)this.dataSource).getContent() == null ? "" : ((TalkSessionBean)this.dataSource).getContent();
    }

    private void updateSessionSenderInfo() {
        if (null != ((TalkSessionBean)this.dataSource).getLastMsgAccount() && !((TalkSessionBean)this.dataSource).getLastMsg().isMine() && ((TalkSessionBean)this.dataSource).getLastMsgType() != 101) {
            this.senderName.setVisibility(0);
            this.senderNameSeparator.setVisibility(0);
            this.updateSenderView(((SessionListAdapterPresenter)this.getPresenter()).getAccount(((TalkSessionBean)this.dataSource).getLastMsgAccount(), 1));
        } else {
            this.senderName.setVisibility(8);
            this.senderNameSeparator.setVisibility(8);
        }
    }

    private void updateSenderView(AccountBean accountBean) {
        if (null == accountBean) {
            return;
        }
        this.senderName.setText((CharSequence)accountBean.getDisplayName());
    }
}

