/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.view;

import android.annotation.TargetApi;
import android.app.Activity;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorRes;
import android.support.annotation.NonNull;
import android.text.Html;
import android.text.TextPaint;
import android.text.TextUtils;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.Transformation;
import com.xdja.im.base.frame.view.AdapterBaseView;
import com.xdja.im.base.frame.view.AdapterSuperBaseView;
import com.xdja.im.common.imageloader.GlideCircleTransform;
import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.core.model.param.SessionParam;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.ui.presenter.SessionListAdapterPresenter;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.utils.sys.TimeUtil;

public class ViewSessionItem
extends AdapterSuperBaseView<SessionListAdapterPresenter, TalkSessionBean>
implements AdapterBaseView<SessionListAdapterPresenter, TalkSessionBean> {
    private LinearLayout mLayout;
    private ImageView mUserHeader;
    private TextView mUnReadCountTv;
    private ImageView mNewMsgFlagImg;
    private TextView mUserNameTv;
    private TextView mContentTv;
    private ImageView mMessageStateImg;
    private TextView mDisplayTimeTv;
    private ImageView mDisturbFlag;

    @Override
    protected void injectView() {
        super.injectView();
        this.mLayout = (LinearLayout)this.findViewById(R.id.layout_session_item);
        this.mUserHeader = (ImageView)this.findViewById(R.id.img_user_header);
        this.mUnReadCountTv = (TextView)this.findViewById(R.id.tv_unread_message);
        this.mNewMsgFlagImg = (ImageView)this.findViewById(R.id.img_new_message_flag);
        this.mUserNameTv = (TextView)this.findViewById(R.id.tv_user_name);
        this.mContentTv = (TextView)this.findViewById(R.id.tv_content);
        this.mMessageStateImg = (ImageView)this.findViewById(R.id.img_message_state);
        this.mDisplayTimeTv = (TextView)this.findViewById(R.id.tv_display_time);
        this.mDisturbFlag = (ImageView)this.findViewById(R.id.img_disturb_flag);
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkSessionBean dataSource) {
        super.bindDataSource(position, dataSource);
        if (dataSource == null) {
            LogUtil.e("dataSource is null.");
            return;
        }
        this.updateSessionSenderInfo();
        this.updateSessionBaseInfo();
        this.updateUnreadCount();
        this.updateMessageState();
        this.updateSessionParam();
    }

    @Override
    public void onViewReused() {
        super.onViewReused();
        int imgId = R.mipmap.im_uikit_user_header_40dp;
        if (((TalkSessionBean)this.dataSource).getTalkType() == 2) {
            imgId = R.mipmap.im_uikit_group_avatar_40;
        }
        this.mUserHeader.setImageResource(imgId);
        this.mUserNameTv.setText((CharSequence)"");
        this.mContentTv.setText((CharSequence)"");
        this.mDisplayTimeTv.setText((CharSequence)"");
        this.mDisturbFlag.setVisibility(8);
        this.mUnReadCountTv.setVisibility(8);
        this.mNewMsgFlagImg.setVisibility(8);
    }

    private void updateSessionSenderInfo() {
        if (null != ((TalkSessionBean)this.dataSource).getLastMsgAccount()) {
            this.updateSenderView(((SessionListAdapterPresenter)this.getPresenter()).getAccount(((TalkSessionBean)this.dataSource).getLastMsgAccount(), 1));
        }
    }

    private void updateSessionBaseInfo() {
        this.updateSessionBaseView(((SessionListAdapterPresenter)this.getPresenter()).getAccount(((TalkSessionBean)this.dataSource).getTalkerAccount(), ((TalkSessionBean)this.dataSource).getTalkType()));
    }

    private void updateSenderView(AccountBean accountBean) {
        if (null == accountBean) {
            return;
        }
        this.mContentTv.setText(this.ellipsize(this.getContent(accountBean.getDisplayName())));
        this.mDisplayTimeTv.setText((CharSequence)this.getDisplayTime());
    }

    private void updateSessionBaseView(AccountBean accountBean) {
        String avatarUrl;
        if (null == accountBean) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)accountBean.getDisplayName())) {
            this.mUserNameTv.setText((CharSequence)accountBean.getDisplayName());
        } else {
            this.mUserNameTv.setText((CharSequence)accountBean.getAccount());
        }
        Drawable avatarDrawable = accountBean.getAvatarDrawable();
        if (avatarDrawable != null) {
            this.mUserHeader.setImageDrawable(avatarDrawable);
            return;
        }
        int imgId = R.mipmap.im_uikit_user_header_40dp;
        if (((TalkSessionBean)this.dataSource).getTalkType() == 2) {
            imgId = R.mipmap.im_uikit_group_avatar_40;
        }
        if (!TextUtils.isEmpty((CharSequence)(avatarUrl = accountBean.getAvatarUrl()))) {
            Glide.with((Activity)this.getActivity()).load(avatarUrl).placeholder(imgId).error(imgId).bitmapTransform(new Transformation[]{new GlideCircleTransform(this.getContext())}).into(this.mUserHeader);
            return;
        }
        this.mUserHeader.setImageResource(imgId);
    }

    private void updateSessionParam() {
        if (((TalkSessionBean)this.dataSource).getParam() != null) {
            if (((TalkSessionBean)this.dataSource).getParam().isTop()) {
                this.mLayout.setBackgroundResource(R.drawable.im_uikit_bg_session_item_top);
            } else {
                this.mLayout.setBackgroundResource(R.drawable.im_uikit_bg_session_item_normal);
            }
            if (((TalkSessionBean)this.dataSource).getParam().isDisturb()) {
                this.mDisturbFlag.setVisibility(0);
            } else {
                this.mDisturbFlag.setVisibility(8);
            }
        } else {
            this.mDisturbFlag.setVisibility(8);
            this.mLayout.setBackgroundResource(R.drawable.im_uikit_bg_session_item_normal);
        }
    }

    private void updateMessageState() {
        TalkMessageBean talkMessageBean = ((TalkSessionBean)this.dataSource).getLastMsg();
        if (talkMessageBean == null) {
            LogUtil.w("session last message is null.");
            return;
        }
        this.mMessageStateImg.setVisibility(8);
        if (talkMessageBean.getMessageType() == 101) {
            return;
        }
        if (talkMessageBean.getFrom() == null || talkMessageBean.getTo() == null) {
            return;
        }
        SessionParam param = ((TalkSessionBean)this.dataSource).getParam();
        if (param != null && !TextUtils.isEmpty((CharSequence)param.getDraftContent()) && param.getDraftTime() > 0L) {
            return;
        }
        if (talkMessageBean.getMessageState() == 1) {
            this.mMessageStateImg.setVisibility(0);
            this.mMessageStateImg.setImageResource(R.mipmap.im_uikit_ic_message_state_sending);
        } else if (talkMessageBean.getMessageState() == 0) {
            this.mMessageStateImg.setVisibility(0);
            this.mMessageStateImg.setImageResource(R.mipmap.im_uikit_ic_message_state_fail);
        }
    }

    private void updateUnreadCount() {
        int notReadCount = ((TalkSessionBean)this.dataSource).getNotReadCount();
        if (notReadCount > 0) {
            this.setNotReadShow(true);
            SessionParam param = ((TalkSessionBean)this.dataSource).getParam();
            if (param != null && param.isDisturb()) {
                this.mUnReadCountTv.setVisibility(8);
                this.mNewMsgFlagImg.setVisibility(0);
                return;
            }
            if (notReadCount > 99) {
                this.setNotReadCount((CharSequence)Html.fromHtml((String)"<b>...</b>"));
            } else {
                this.setNotReadCount(notReadCount + "");
            }
        } else {
            this.setNotReadShow(false);
        }
    }

    private void setNotReadShow(boolean isShow) {
        if (isShow) {
            this.mUnReadCountTv.setVisibility(0);
        } else {
            this.mUnReadCountTv.setVisibility(8);
        }
        this.mNewMsgFlagImg.setVisibility(8);
    }

    private void setNotReadCount(CharSequence countText) {
        this.mUnReadCountTv.setText(countText);
    }

    private void setTextColor(@ColorRes int idRes) {
        this.mContentTv.setTextColor(this.getColorRes(idRes));
    }

    protected String getUserName() {
        return ((TalkSessionBean)this.dataSource).getLastMsgAccount();
    }

    protected CharSequence getContent(String displayName) {
        return "";
    }

    protected String getDisplayTime() {
        if (((TalkSessionBean)this.dataSource).getLastTime() > 0L) {
            return TimeUtil.convertSessionTime(((TalkSessionBean)this.dataSource).getLastTime());
        }
        return "";
    }

    public void setTimeVisibility(int visibility) {
        this.mDisplayTimeTv.setVisibility(visibility);
    }

    protected CharSequence formatDraft(String content) {
        String draftPreStr = "<font color=\"#941100\">" + this.getStringRes(R.string.im_uikit_draft) + "</font>";
        return Html.fromHtml((String)(draftPreStr + content));
    }

    @TargetApi(value=16)
    protected CharSequence ellipsize(CharSequence content) {
        return TextUtils.ellipsize((CharSequence)content, (TextPaint)this.mContentTv.getPaint(), (float)(this.mContentTv.getMaxWidth() - 8), (TextUtils.TruncateAt)TextUtils.TruncateAt.END);
    }
}

