/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.utils.log.klog;

import android.util.Log;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.utils.log.Printer;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XmlLog {
    public static void printXml(String tag, String xml, String headString) {
        String[] lines;
        if (xml != null) {
            xml = XmlLog.formatXML(xml);
            xml = headString + "\n" + xml;
        } else {
            xml = headString + "Log with null object";
        }
        Printer.printLine(tag, true);
        for (String line : lines = xml.split(LogUtil.LINE_SEPARATOR)) {
            if (Printer.isEmpty(line)) continue;
            Log.d((String)tag, (String)("\u2551 " + line));
        }
        Printer.printLine(tag, false);
    }

    private static String formatXML(String inputXML) {
        try {
            StreamSource xmlInput = new StreamSource(new StringReader(inputXML));
            StreamResult xmlOutput = new StreamResult(new StringWriter());
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(xmlInput, xmlOutput);
            return xmlOutput.getWriter().toString().replaceFirst(">", ">\n");
        }
        catch (Exception e) {
            e.printStackTrace();
            return inputXML;
        }
    }
}

