/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.http.client.protocol;

import com.xdja.http.HttpException;
import com.xdja.http.HttpRequest;
import com.xdja.http.HttpRequestInterceptor;
import com.xdja.http.annotation.Immutable;
import com.xdja.http.client.config.RequestConfig;
import com.xdja.http.client.protocol.HttpClientContext;
import com.xdja.http.protocol.HttpContext;
import java.io.IOException;
import java.util.List;

@Immutable
public class RequestAcceptEncoding
implements HttpRequestInterceptor {
    private final String acceptEncoding;

    public RequestAcceptEncoding(List<String> encodings) {
        if (encodings != null && !encodings.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < encodings.size(); ++i) {
                if (i > 0) {
                    buf.append(",");
                }
                buf.append(encodings.get(i));
            }
            this.acceptEncoding = buf.toString();
        } else {
            this.acceptEncoding = "gzip,deflate";
        }
    }

    public RequestAcceptEncoding() {
        this(null);
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RequestConfig requestConfig = clientContext.getRequestConfig();
        if (!request.containsHeader("Accept-Encoding") && requestConfig.isContentCompressionEnabled()) {
            request.addHeader("Accept-Encoding", this.acceptEncoding);
        }
    }
}

