/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.http.impl;

import com.xdja.http.HttpResponse;
import com.xdja.http.HttpResponseFactory;
import com.xdja.http.ProtocolVersion;
import com.xdja.http.ReasonPhraseCatalog;
import com.xdja.http.StatusLine;
import com.xdja.http.annotation.Immutable;
import com.xdja.http.impl.EnglishReasonPhraseCatalog;
import com.xdja.http.message.BasicHttpResponse;
import com.xdja.http.message.BasicStatusLine;
import com.xdja.http.protocol.HttpContext;
import com.xdja.http.util.Args;
import java.util.Locale;

@Immutable
public class DefaultHttpResponseFactory
implements HttpResponseFactory {
    public static final DefaultHttpResponseFactory INSTANCE = new DefaultHttpResponseFactory();
    protected final ReasonPhraseCatalog reasonCatalog;

    public DefaultHttpResponseFactory(ReasonPhraseCatalog catalog) {
        this.reasonCatalog = Args.notNull(catalog, "Reason phrase catalog");
    }

    public DefaultHttpResponseFactory() {
        this(EnglishReasonPhraseCatalog.INSTANCE);
    }

    @Override
    public HttpResponse newHttpResponse(ProtocolVersion ver, int status, HttpContext context) {
        Args.notNull(ver, "HTTP version");
        Locale loc = this.determineLocale(context);
        String reason = this.reasonCatalog.getReason(status, loc);
        BasicStatusLine statusline = new BasicStatusLine(ver, status, reason);
        return new BasicHttpResponse(statusline, this.reasonCatalog, loc);
    }

    @Override
    public HttpResponse newHttpResponse(StatusLine statusline, HttpContext context) {
        Args.notNull(statusline, "Status line");
        return new BasicHttpResponse(statusline, this.reasonCatalog, this.determineLocale(context));
    }

    protected Locale determineLocale(HttpContext context) {
        return Locale.getDefault();
    }
}

