/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.http.impl.cookie;

import com.xdja.http.annotation.Immutable;
import com.xdja.http.cookie.CommonCookieAttributeHandler;
import com.xdja.http.cookie.Cookie;
import com.xdja.http.cookie.CookieOrigin;
import com.xdja.http.cookie.MalformedCookieException;
import com.xdja.http.cookie.SetCookie;
import com.xdja.http.impl.cookie.AbstractCookieAttributeHandler;
import com.xdja.http.util.Args;

@Immutable
public class BasicSecureHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        cookie.setSecure(true);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        return !cookie.isSecure() || origin.isSecure();
    }

    @Override
    public String getAttributeName() {
        return "secure";
    }
}

