/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.util;

import android.text.TextUtils;
import com.xdja.google.gson.Gson;
import com.xdja.google.gson.JsonSyntaxException;
import com.xdja.google.gson.reflect.TypeToken;
import com.xdja.imsdk.logger.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonUtils {
    private static Gson gson = new Gson();

    public static String getString(JSONObject jsonObject, String key) {
        String value = "";
        try {
            if (jsonObject.has(key)) {
                value = jsonObject.getString(key);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return value;
    }

    public static int getInt(JSONObject jsonObject, String key) {
        int value = 0;
        try {
            value = jsonObject.getInt(key);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return value;
    }

    public static Gson getGson() {
        return gson;
    }

    public static <T> T mapGson(String json, Class<T> cls) {
        if (TextUtils.isEmpty((CharSequence)json)) {
            return null;
        }
        Object result = null;
        try {
            result = gson.fromJson(json.trim(), TypeToken.get(cls).getType());
        }
        catch (JsonSyntaxException e) {
            Logger.getLogger().e("im json exception " + json);
            return null;
        }
        return (T)result;
    }
}

