/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.volley.request;

import com.xdja.imsdk.volley.NetworkResponse;
import com.xdja.imsdk.volley.Request;
import com.xdja.imsdk.volley.Response;
import com.xdja.imsdk.volley.toolbox.HttpHeaderParser;
import java.io.UnsupportedEncodingException;

public class StringRequest
extends Request<String> {
    private final Response.Listener<String> mListener;

    public StringRequest(String url, Response.Listener<String> listener, Response.ErrorListener errorListener) {
        this(0, url, listener, errorListener);
    }

    public StringRequest(int method, String url, Response.Listener<String> listener, Response.ErrorListener errorListener) {
        this(method, url, listener, errorListener, null);
    }

    public StringRequest(int method, String url, Response.Listener<String> listener, Response.ErrorListener errorListener, Response.LoadingListener loadingListener) {
        super(method, url, errorListener, loadingListener);
        this.mListener = listener;
    }

    @Override
    protected void deliverResponse(String response) {
        this.mListener.onResponse(response);
    }

    @Override
    protected Response<String> parseNetworkResponse(NetworkResponse response) {
        String parsed;
        try {
            parsed = new String(response.data, HttpHeaderParser.parseCharset(response.headers));
        }
        catch (UnsupportedEncodingException e) {
            parsed = new String(response.data);
        }
        catch (NullPointerException e) {
            parsed = "";
        }
        return Response.success(parsed, HttpHeaderParser.parseCacheHeaders(response));
    }
}

