package com.xdja.im.common.cache.impl;

import android.support.annotation.Nullable;
import android.text.TextUtils;

import com.xdja.im.common.cache.entity.DeviceEntity;
import com.xdja.im.common.cache.entity.ServerEntity;
import com.xdja.im.common.cache.interf.ConfigCache;
import com.xdja.im.common.network.entity.ServerAddr;
import com.xdja.im.common.persistent.PropertyUtil;

import java.util.HashMap;
import java.util.Map;

import javax.inject.Inject;

/**
 * @Package:com.xdja.im.common.cache
 * @Author:Lei
 * @Creation:2017-04-11 22:15
 * @Version 1.0
 * @Description:配置信息缓存实现
 */
public class ConfigCacheImpl implements ConfigCache {

    public static final String PRONAME = "im_uikit_config.conf";

    public static final String DEVICE_TYPE = "deviceType";
    public static final String PLATFORM_TYPE = "platformType";
    public static final String SERVER_IM_URL = "imUrl";
    public static final String SERVER_MX_URL = "mxUrl";
    public static final String SERVER_FASTDFS_ADDR = "fastDfsAddr";
    public static final String SERVER_FASTDFS_PORT = "fastDfsPort";

    public static final int DEFAULT_DEVICE_TYPE = 1; //默认设备类型：phone
    public static final int DEFAULT_PLATFORM_TYPE = 0; //默认平台类型：通用

    private Map<String, String> configEntity;

    private DeviceEntity deviceEntity;

    private ServerEntity serverEntity;

    private PropertyUtil propertyUtil;

    @Inject
    public ConfigCacheImpl(PropertyUtil propertyUtil) {
        this.propertyUtil = propertyUtil;
    }

    @Nullable
    @Override
    public Map<String, String> get() {
        configEntity = new HashMap<>();
        this.propertyUtil.load(PRONAME);
        this.configEntity = this.propertyUtil.getAll();
        return configEntity;
    }

    @Override
    public DeviceEntity getDevice() {
        if (configEntity == null || configEntity.isEmpty()) {
            configEntity = this.get();
        }
        if (deviceEntity == null) {
            deviceEntity = new DeviceEntity();
            int deviceId = DEFAULT_DEVICE_TYPE;
            int platform = DEFAULT_PLATFORM_TYPE;
            try {
                deviceId = TextUtils.isEmpty(configEntity.get(DEVICE_TYPE)) ? 1 :
                        Integer.valueOf(configEntity.get(DEVICE_TYPE));
                platform = TextUtils.isEmpty(configEntity.get(PLATFORM_TYPE)) ? 0 :
                        Integer.valueOf(configEntity.get(PLATFORM_TYPE));
            } catch (Exception e) {
                e.printStackTrace();
            }
            deviceEntity.setDeviceType(deviceId);
            deviceEntity.setPlatformType(platform);

        }
        return deviceEntity;
    }

    @Override
    public ServerEntity getServer() {
        if (configEntity == null || configEntity.isEmpty()) {
            configEntity = this.get();
        }
        if (serverEntity == null) {
            serverEntity = new ServerEntity();
            serverEntity.setImUrl(configEntity.get(SERVER_IM_URL));
            serverEntity.setMxUrl(configEntity.get(SERVER_MX_URL));

            ServerAddr serverAddr = new ServerAddr(
                    configEntity.get(SERVER_FASTDFS_ADDR),
                    configEntity.get(SERVER_FASTDFS_PORT)
            );
            serverEntity.setFastDfsUrl(serverAddr);
        }
        return serverEntity;
    }
}
