package com.xdja.im.common.network;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

import okhttp3.ResponseBody;
import retrofit2.Converter;
import retrofit2.Retrofit;

/**
 * @Package: com.xdja.im.common.network
 * @Author: xdjaxa
 * @Creation: 2017-06-03 15:02
 * @Version V1.0
 * @Description:
 */
public class EmptyBodyConverterFactory extends Converter.Factory {

    @Override
    public Converter<ResponseBody, ?> responseBodyConverter(Type type, Annotation[] annotations, Retrofit retrofit) {
        final Converter<ResponseBody, ?> delegate = retrofit.nextResponseBodyConverter(this, type, annotations);
        return new Converter<ResponseBody, Object>() {

            @Override
            public Object convert(ResponseBody body) throws IOException {
                if (body == null || body.contentLength() == 0) {
                    return null;
                }
                return delegate.convert(body);
            }
        };
    }
}
