package com.xdja.im.common.network;

import com.xdja.im.common.cache.interf.ConfigCache;

import javax.inject.Inject;

import retrofit2.Retrofit;
import retrofit2.adapter.rxjava.RxJavaCallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

/**
 * @Package: com.xdja.im.common.network
 * @Author: xdjaxa
 * @Creation: 2017-05-31 17:01
 * @Version V1.0
 * @Description:
 */
public class RestAdapterMe {

    private Retrofit.Builder builder;

    private OkHttpsClientMe okHttpClient;

    private ConfigCache configCache;

    @Inject
    public RestAdapterMe(OkHttpsClientMe okHttpClient,
                         ConfigCache configCache) {
        this.okHttpClient = okHttpClient;
        this.configCache = configCache;
    }

    public Retrofit getRetrofit() {
        if (null != builder) {
            builder.baseUrl(configCache.getServer().getMxUrl());
        } else {
            builder = new Retrofit.Builder()
                    .baseUrl(configCache.getServer().getMxUrl())
                    .client(okHttpClient.createBuilder().build())
                    .addConverterFactory(new EmptyBodyConverterFactory())
                    .addConverterFactory(GsonConverterFactory.create())
                    .addCallAdapterFactory(RxJavaCallAdapterFactory.create());
        }
        return builder.build();
    }


}
