package com.xdja.im.common.utils;


import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;

public class DateUtils {


    private static final Map<String, ThreadLocal<SimpleDateFormat>> sdfMap = new HashMap<>();

    private static final String FORMAT_YMDHM = "yyyy-MM-dd HH:mm";

    public static final String FORMAT_HH_MM = "HH:mm";

    /**
     * 根据map中的key值，获取对应线程中的SimpleDateFormat实例
     * @param pattern
     * @return
     */
    private static SimpleDateFormat getFormat(final String pattern) {

        ThreadLocal<SimpleDateFormat> formatThread = sdfMap.get(pattern);
        if (formatThread == null) {
            //双层检查，防止sdfMap多次放值
            synchronized (DateUtils.class) {
                formatThread = new ThreadLocal<SimpleDateFormat>() {

                    @Override
                    protected SimpleDateFormat initialValue() {
                        return new SimpleDateFormat(pattern);
                    }
                };
                sdfMap.put(pattern, formatThread);
            }
        }
        return formatThread.get();
    }

    /**
     * 文件相关时间进行转化
     *
     * @param timestamp
     * @return
     */
    public static String convertFileModifyDate(long timestamp) {
        if (timestamp == 0) {
            return "";
        }
        return getFormat(FORMAT_YMDHM).format(timestamp);
    }

    /**
     *
     * @param timestamp
     * @return
     */
    public static String getDisplayTime(long timestamp) {
        return getFormat(FORMAT_HH_MM).format(timestamp);
    }
}
