package com.xdja.im.core.repository.impl.im;

import android.text.TextUtils;
import android.util.Log;

import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.model.message.mapper.DataMapper;
import com.xdja.im.core.repository.impl.SecurityImpl;
import com.xdja.im.core.repository.interf.SecurityRepository;
import com.xdja.im.core.repository.interf.im.IMProxyCallBack;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.imsdk.callback.CallbackFunction;
import com.xdja.imsdk.callback.IMFileInfoCallback;
import com.xdja.imsdk.callback.IMMessageCallback;
import com.xdja.imsdk.callback.IMSecurityCallback;
import com.xdja.imsdk.callback.IMSessionCallback;
import com.xdja.imsdk.constant.ChangeAction;
import com.xdja.imsdk.constant.StateCode;
import com.xdja.imsdk.model.IMFileInfo;
import com.xdja.imsdk.model.IMMessage;
import com.xdja.imsdk.model.IMSession;
import com.xdja.imsdk.security.SecurityPara;
import com.xdja.imsdk.security.SecurityResult;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.inject.Inject;

/**
 * @Package: com.xdja.im.core.callback
 * @Author: xdjaxa
 * @Creation: 2017-04-11 13:51
 * @Version V1.0
 * @Description:IMSDK回调句柄
 */
public class IMSDKCallBack implements CallbackFunction,
        IMFileInfoCallback,
        IMSessionCallback,
        IMMessageCallback,
        IMSecurityCallback {

    private DataMapper mapper;
    private IMProxyCallBack callBack;
    private SecurityRepository repository;

    @Inject
    public IMSDKCallBack(
            DataMapper mapper,
            IMProxyCallBack callBack,
            SecurityRepository repository) {
        this.mapper = mapper;
        this.callBack = callBack;
        this.repository = repository;
    }

    @Override
    public int NewIMMessageCome(IMSession session, List<IMMessage> messageList) {
        if (messageList == null || messageList.size() < 0 || session == null) {
            return ConstDef.CALLBACK_NOT_HANDLED;
        }
        TalkSessionBean sessionBean = mapper.mapTalkSessionBean(session);
        Log.d("NewMsgCome", "sessionBean:" + sessionBean);
        List<TalkMessageBean> talkMessageBeanList = new ArrayList<>();
        for (IMMessage message : messageList) {
            TalkMessageBean talkMessageBean = mapper.mapTalkMessageBean(message);
            talkMessageBeanList.add(talkMessageBean);
        }
        return callBack.onRemainNewMessage(sessionBean, talkMessageBeanList);
    }

    @Override
    public int IMSessionListChange(IMSession imSession, ChangeAction action) {
        TalkSessionBean talkSessionBean = mapper.mapTalkSessionBean(imSession);
        if (talkSessionBean == null) {
            return ConstDef.CALLBACK_NOT_HANDLED;
        }
        switch (action) {
            case ACT_ADD:
                return callBack.onCreateNewSession(talkSessionBean);
            case ACT_DEL:
                return callBack.onDeleteSession(talkSessionBean);
            case ACT_RF:
            case ACT_SC:
                return callBack.onRefreshSession(talkSessionBean);
            default:
                return ConstDef.CALLBACK_NOT_HANDLED;
        }
    }

    @Override
    public int IMMessageListChange(IMSession session, List<IMMessage> messageList, ChangeAction action) {

        List<TalkMessageBean> msgBeanList = new ArrayList<>();
        for (int i = 0; i < messageList.size(); i++) {
            TalkMessageBean talkMessageBean = mapper.mapTalkMessageBean(messageList.get(i));
            msgBeanList.add(talkMessageBean);
        }

        TalkMessageBean talkMessageBean = msgBeanList.get(0);
        TalkSessionBean talkSessionBean = mapper.mapTalkSessionBean(session);
        switch (action) {
            case ACT_ADD:
                return callBack.onReceiveNewMessage(talkSessionBean.getTalkerAccount(), msgBeanList);
            case ACT_DEL:
                return callBack.onDeleteMessage(talkSessionBean.getTalkerAccount(), talkMessageBean);
            case ACT_RF:
                return callBack.refreshMessageList();
            case ACT_SC:
                if (!talkMessageBean.isMine()
                        && talkMessageBean.isBomb()
                        && talkMessageBean.getMessageState() == ConstDef.STATE_DESTROY) {
                    talkMessageBean.setMessageState(ConstDef.STATE_DESTROYING);
                }
                return callBack.onRefreshMessage(talkSessionBean.getTalkerAccount(), talkMessageBean);
            default:
                return ConstDef.CALLBACK_NOT_HANDLED;
        }
    }

    @Override
    public int IMMessageRecall(IMSession session, IMMessage message, int recallCode) {
        return 0;
    }

    @Override
    public int ImSdkStateChange(int code) {
        LogUtil.d("ImSdkStateChange:" + code);
        if (code == StateCode.SDK_SERVICE_OK) {

            return callBack.onInitFinished();

        } else if (code == StateCode.SDK_CONNECTED_OK) {

        } else if (code == StateCode.SDK_TICKET_EXPIRE) {

        } else {

        }
        return 0;
    }

    @Override
    public int ImSdkNetworkChange(int i) {
        return 0;
    }

    @Override
    public int CheckVersion(String account) {
        return 0;
    }

    @Override
    public String GetNoticeByAccount(String s, String s1) {
        return null;
    }

    @Override
    public String GetSendMessageParamExt() {
        // TODO: 2017/5/23 按照不同的平台进行配置
        return "{\"checkFri\":0}";
    }

    @Override
    public void CacheSize(boolean b, long l) {

    }

    /**
     * 自定义log
     *
     * @param priority  priority
     * @param tag       tag
     * @param msg       ms
     * @param throwable throwable
     */
    @Override
    public void ImSdkLog(int priority, String tag, String msg, Throwable throwable) {
        switch (priority) {
            case Log.INFO:
                Log.i(tag, msg);
                break;
            case Log.DEBUG:
                Log.d(tag, msg);
                break;
            case Log.ERROR:
                Log.e(tag, msg);
                break;
            case Log.VERBOSE:
                Log.v(tag, msg);
                break;
            case Log.WARN:
                Log.w(tag, msg);
                break;
        }
    }

    @Override
    public int SendFileProgressUpdate(IMFileInfo imFileInfo) {
        FileInfo fileInfo = mapper.mapFileInfo(imFileInfo);
        if (fileInfo == null) {
            return ConstDef.CALLBACK_NOT_HANDLED;
        }
        IMMessage message = imFileInfo.getMessage();
        return callBack.onSendFileProgressUpdate(
                imFileInfo.getTag(),
                message.getIMMessageId(),
                fileInfo,
                imFileInfo.getPercent()
        );
    }

    @Override
    public int SendFileFail(IMFileInfo imFileInfo) {
        FileInfo fileInfo = mapper.mapFileInfo(imFileInfo);
        if (fileInfo == null) {
            return ConstDef.CALLBACK_NOT_HANDLED;
        }
        IMMessage message = imFileInfo.getMessage();
        return callBack.onSendFileFailed(
                imFileInfo.getTag(),
                message.getIMMessageId(),
                fileInfo,
                0);
    }

    @Override
    public int SendFileFinish(IMFileInfo imFileInfo) {
        FileInfo fileInfo = mapper.mapFileInfo(imFileInfo);
        if (fileInfo == null) {
            return ConstDef.CALLBACK_NOT_HANDLED;
        }
        IMMessage message = imFileInfo.getMessage();
        return callBack.onSendFileFinished(
                imFileInfo.getTag(),
                message.getIMMessageId(),
                fileInfo
        );
    }

    @Override
    public int ReceiveFileProgressUpdate(IMFileInfo imFileInfo) {
        FileInfo fileInfo = mapper.mapFileInfo(imFileInfo);
        if (fileInfo == null) {
            return ConstDef.CALLBACK_NOT_HANDLED;
        }

        IMMessage message = imFileInfo.getMessage();
        return callBack.onReceiveFileProgressUpdate(
                imFileInfo.getTag(),
                message.getIMMessageId(),
                fileInfo,
                imFileInfo.getPercent());
    }

    @Override
    public int ReceiveFileFail(IMFileInfo imFileInfo) {
        FileInfo fileInfo = mapper.mapFileInfo(imFileInfo);
        if (fileInfo == null) {
            return ConstDef.CALLBACK_NOT_HANDLED;
        }
        IMMessage message = imFileInfo.getMessage();
        return callBack.onReceiveFileFailed(
                imFileInfo.getTag(),
                message.getIMMessageId(),
                fileInfo,
                0
        );
    }

    @Override
    public int ReceiveFileFinish(IMFileInfo imFileInfo) {
        FileInfo fileInfo = mapper.mapFileInfo(imFileInfo);
        if (fileInfo == null) {
            return ConstDef.CALLBACK_NOT_HANDLED;
        }

        IMMessage message = imFileInfo.getMessage();
        return callBack.onReceiveFileFinished(
                imFileInfo.getTag(),
                message.getIMMessageId(),
                fileInfo
        );
    }

    @Override
    public int ReceiveFilePaused(IMFileInfo imFileInfo) {
        FileInfo fileInfo = mapper.mapFileInfo(imFileInfo);
        if (fileInfo == null) {
            return ConstDef.CALLBACK_NOT_HANDLED;
        }

        IMMessage message = imFileInfo.getMessage();
        return callBack.onReceiveFilePaused(
                imFileInfo.getTag(),
                message.getIMMessageId(),
                fileInfo
        );
    }

    @Override
    public SecurityResult EncryptText(String source, SecurityPara para) {

        //非加密模块
        /*SecurityResult securityResult = new SecurityResult(SecurityResult.SECURITY_SUCCESS);
        securityResult.setResult(source);
        return securityResult;*/


        //加密模块
        SecurityResult result = new SecurityResult(SecurityResult.SECURITY_NON);

        if (TextUtils.isEmpty(source)) {
            result.setResult(source);
            return result;
        }

        String to = para.getPerson();
        boolean isGroup = para.isGroup();

        Map<String, Object> text = repository.encryptText(source, to, isGroup);

        return getSecurityResult(text);
    }

    @Override
    public SecurityResult EncryptFile(String source, String dest, SecurityPara para) {

        //非加密模块
        /*SecurityResult securityResult = new SecurityResult(SecurityResult.SECURITY_SUCCESS);
        securityResult.setResult(source);
        return securityResult;*/

        //加密模块
        SecurityResult result = new SecurityResult(SecurityResult.SECURITY_NON);

        if (TextUtils.isEmpty(source)) {
            result.setResult(source);
            return result;
        }

        String to = para.getPerson();
        boolean isGroup = para.isGroup();

        Map<String, Object> file = repository.encryptAsync(source, dest, to, isGroup);

        return getSecurityResult(file);
    }

    @Override
    public SecurityResult DecryptText(String source, SecurityPara para) {
        return null;
    }

    @Override
    public SecurityResult DecryptFile(String source, String dest, SecurityPara para) {
        return null;
    }

    /**
     * 解析加解密结果
     *
     * @param security security
     * @return SecurityResult
     */
    private SecurityResult getSecurityResult(Map<String, Object> security) {
        SecurityResult securityResult = new SecurityResult(SecurityResult.SECURITY_NON);

        int code = (int) security.get(SecurityImpl.SECURITY_CODE);
        String result = (String) security.get(SecurityImpl.SECURITY_RESULT);

        if (code != SecurityImpl.SECURITY_SUCCESS) {
            return getFailResult(code, result);
        }

        securityResult.setResult(result);
        securityResult.setCode(SecurityResult.SECURITY_SUCCESS);
        return securityResult;
    }

    /**
     * 生成失败结果
     *
     * @param code   code
     * @param source source
     * @return SecurityResult
     */
    private SecurityResult getFailResult(int code, String source) {
        SecurityResult result = new SecurityResult(SecurityResult.SECURITY_NON);

        if (code == SecurityImpl.SECURITY_FAIL) {
            result.setCode(SecurityResult.SECURITY_FAIL);
        }

        if (code == SecurityImpl.NO_DECRYPT) {
            result.setCode(SecurityResult.SECURITY_NON);
        }

        result.setResult(source);
        return result;
    }
}
